/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.protocol.session;

import com.tinkerpop.rexster.protocol.session.RexProSessions;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;

public class RexProSessionMonitor
extends Thread {
    private static final long MIN_UPDATE_INTERVAL = 1000L;
    private static final long MIN_IDLE_TIME = 60000L;
    private final AtomicLong updateInterval = new AtomicLong();
    private final AtomicLong maxIdleTime = new AtomicLong();
    private final AtomicLong lastCheck = new AtomicLong(System.currentTimeMillis());

    public RexProSessionMonitor() {
        this.setDaemon(true);
        this.reconfigure(1000L, 60000L);
        this.start();
    }

    public void reconfigure(long updateInterval, long maxIdleTime) {
        if (updateInterval < 1000L) {
            this.updateInterval.set(1000L);
        } else {
            this.updateInterval.set(updateInterval);
        }
        if (maxIdleTime < 60000L) {
            this.maxIdleTime.set(60000L);
        } else {
            this.maxIdleTime.set(maxIdleTime);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.updateInterval.get() <= System.currentTimeMillis() - this.lastCheck.get()) continue;
            Collection<String> sessionKeys = RexProSessions.getSessionKeys();
            for (String sessionKey : sessionKeys) {
                if (!RexProSessions.hasSessionKey(sessionKey) || RexProSessions.getSession(sessionKey).getIdleTime() <= this.maxIdleTime.get()) continue;
                RexProSessions.destroySession(sessionKey);
            }
            this.lastCheck.set(System.currentTimeMillis());
        }
    }
}

