/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.addons;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonDependency;
import org.jboss.forge.furnace.addons.AddonFilter;
import org.jboss.forge.furnace.addons.AddonView;
import org.jboss.forge.furnace.event.PostStartup;
import org.jboss.forge.furnace.event.PreShutdown;
import org.jboss.forge.furnace.exception.ContainerException;
import org.jboss.forge.furnace.impl.addons.AddonLifecycleManager;
import org.jboss.forge.furnace.impl.addons.AddonStateManager;
import org.jboss.forge.furnace.impl.util.ExceptionFuture;
import org.jboss.forge.furnace.lifecycle.AddonLifecycleProvider;
import org.jboss.forge.furnace.lifecycle.ControlType;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.util.Addons;
import org.jboss.forge.furnace.util.ClassLoaders;
import org.jboss.forge.furnace.util.Iterators;
import org.jboss.forge.furnace.util.SecurityActions;

public final class AddonRunnable
implements Runnable {
    private static final Logger logger = Logger.getLogger(AddonRunnable.class.getName());
    private boolean shutdownRequested = false;
    private final Furnace furnace;
    private final Addon addon;
    private final AddonLifecycleManager lifecycleManager;
    private final AddonStateManager stateManager;
    private AddonLifecycleProviderEntry lifecycleProviderEntry;
    private final AddonFilter notThisAddonFilter = new AddonFilter(){

        public boolean accept(Addon other) {
            return !other.equals(AddonRunnable.this.addon);
        }
    };

    public AddonRunnable(Furnace furnace, AddonLifecycleManager lifecycleManager, AddonStateManager stateManager, Addon addon) {
        this.lifecycleManager = lifecycleManager;
        this.stateManager = stateManager;
        this.furnace = furnace;
        this.addon = addon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread currentThread = Thread.currentThread();
        String name = currentThread.getName();
        currentThread.setName(this.addon.getId().toCoordinates());
        try {
            logger.info("> Starting container [" + this.addon.getId() + "] [" + this.addon.getRepository().getRootDirectory() + "]");
            long start = System.currentTimeMillis();
            this.lifecycleProviderEntry = this.detectLifecycleProvider();
            if (this.lifecycleProviderEntry != null) {
                final AddonLifecycleProvider lifecycleProvider = this.lifecycleProviderEntry.getProvider();
                ClassLoaders.executeIn((ClassLoader)this.addon.getClassLoader(), (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        lifecycleProvider.initialize(AddonRunnable.this.furnace, AddonRunnable.this.furnace.getAddonRegistry(AddonRunnable.this.getRepositories()), AddonRunnable.this.lifecycleProviderEntry.getAddon());
                        lifecycleProvider.start(AddonRunnable.this.addon);
                        AddonRunnable.this.stateManager.setServiceRegistry(AddonRunnable.this.addon, lifecycleProvider.getServiceRegistry(AddonRunnable.this.addon));
                        AddonRunnable.this.stateManager.setEventManager(AddonRunnable.this.addon, lifecycleProvider.getEventManager(AddonRunnable.this.addon));
                        for (AddonDependency dependency : AddonRunnable.this.addon.getDependencies()) {
                            if (!dependency.getDependency().getStatus().isLoaded()) continue;
                            Addons.waitUntilStarted((Addon)dependency.getDependency());
                        }
                        lifecycleProvider.postStartup(AddonRunnable.this.addon);
                        for (AddonView view : AddonRunnable.this.stateManager.getViewsOf(AddonRunnable.this.addon)) {
                            for (Addon a : view.getAddons(AddonRunnable.this.notThisAddonFilter)) {
                                a.getEventManager().fireEvent((Object)new PostStartup(AddonRunnable.this.addon), new Annotation[0]);
                            }
                        }
                        return null;
                    }
                });
            }
            logger.info(">> Started container [" + this.addon.getId() + "] - " + (System.currentTimeMillis() - start) + "ms");
        }
        catch (Throwable e) {
            this.addon.getFuture().cancel(false);
            this.stateManager.setHandles(this.addon, new ExceptionFuture<Void>(e), this);
            Level level = Level.FINEST;
            if (!this.shutdownRequested) {
                level = Level.SEVERE;
            }
            logger.log(level, "Failed to start addon [" + this.addon.getId() + "] with classloader [" + this.stateManager.getClassLoaderOf(this.addon) + "]", e);
        }
        finally {
            this.lifecycleManager.finishedStarting(this.addon);
            SecurityActions.cleanupThreadLocals((Thread)Thread.currentThread());
            currentThread.setName(name);
            currentThread.setContextClassLoader(null);
        }
    }

    protected AddonRepository[] getRepositories() {
        Set repositories = this.stateManager.getViewsOf(this.addon).iterator().next().getRepositories();
        return repositories.toArray(new AddonRepository[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdownRequested = true;
        try {
            logger.info("< Stopping container [" + this.addon.getId() + "] [" + this.addon.getRepository().getRootDirectory() + "]");
            long start = System.currentTimeMillis();
            if (this.lifecycleProviderEntry != null) {
                final AddonLifecycleProvider lifecycleProvider = this.lifecycleProviderEntry.getProvider();
                ClassLoaders.executeIn((ClassLoader)this.addon.getClassLoader(), (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try {
                            for (AddonView view : AddonRunnable.this.stateManager.getViewsOf(AddonRunnable.this.addon)) {
                                for (Addon a : view.getAddons(AddonRunnable.this.notThisAddonFilter)) {
                                    try {
                                        a.getEventManager().fireEvent((Object)new PreShutdown(AddonRunnable.this.addon), new Annotation[0]);
                                    }
                                    catch (Throwable t) {
                                        logger.log(Level.FINE, "Failed to execute pre-shutdown task for [" + AddonRunnable.this.addon + "] in event manager from " + a.getId(), t);
                                    }
                                }
                            }
                            lifecycleProvider.preShutdown(AddonRunnable.this.addon);
                        }
                        catch (Throwable e) {
                            logger.log(Level.FINE, "Failed to execute pre-shutdown task for [" + AddonRunnable.this.addon + "]", e);
                        }
                        lifecycleProvider.stop(AddonRunnable.this.addon);
                        return null;
                    }
                });
            }
            logger.info("<< Stopped container [" + this.addon.getId() + "] - " + (System.currentTimeMillis() - start) + "ms");
        }
        catch (Throwable e) {
            logger.log(Level.FINE, "Failed to shut down addon " + this.addon.getId(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(null);
        }
    }

    private AddonLifecycleProviderEntry detectLifecycleProvider() {
        AddonLifecycleProviderEntry result = null;
        result = this.detectLifecycleProviderLocal();
        if (result == null) {
            result = this.detectLifecycleProviderDependencies();
        }
        return result;
    }

    private AddonLifecycleProviderEntry detectLifecycleProviderLocal() {
        AddonLifecycleProviderEntry result = null;
        final ClassLoader classLoader = this.addon.getClassLoader();
        try {
            result = (AddonLifecycleProviderEntry)ClassLoaders.executeIn((ClassLoader)classLoader, (Callable)new Callable<AddonLifecycleProviderEntry>(){

                @Override
                public AddonLifecycleProviderEntry call() throws Exception {
                    AddonLifecycleProviderEntry result = null;
                    ServiceLoader<AddonLifecycleProvider> serviceLoader = ServiceLoader.load(AddonLifecycleProvider.class, classLoader);
                    Iterator<AddonLifecycleProvider> iterator = serviceLoader.iterator();
                    while (serviceLoader != null && iterator.hasNext()) {
                        AddonLifecycleProvider provider = iterator.next();
                        if (!ClassLoaders.ownsClass((ClassLoader)classLoader, provider.getClass())) continue;
                        ControlType controlType = provider.getControlType();
                        if (ControlType.ALL.equals((Object)controlType)) {
                            result = new AddonLifecycleProviderEntry(AddonRunnable.this.addon, provider);
                        }
                        if (ControlType.SELF.equals((Object)controlType)) {
                            result = new AddonLifecycleProviderEntry(AddonRunnable.this.addon, provider);
                        }
                        if (result == null || !iterator.hasNext()) continue;
                        throw new ContainerException("Expected only one [" + AddonLifecycleProvider.class.getName() + "] but found multiple. Remove all but one redundant container implementations: " + Iterators.asList(serviceLoader));
                    }
                    return result;
                }
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContainerException("Error occurred while attempting to local instance of [" + AddonLifecycleProvider.class.getName() + "] for addon [" + this.addon + "].");
        }
        return result;
    }

    private AddonLifecycleProviderEntry detectLifecycleProviderDependencies() {
        ArrayList<AddonLifecycleProviderEntry> results = new ArrayList<AddonLifecycleProviderEntry>();
        for (AddonDependency addonDependency : this.addon.getDependencies()) {
            Addon dependency = addonDependency.getDependency();
            ClassLoader classLoader = dependency.getClassLoader();
            try {
                AddonLifecycleProvider provider;
                AddonLifecycleProviderEntry result = null;
                ServiceLoader<AddonLifecycleProvider> serviceLoader = ServiceLoader.load(AddonLifecycleProvider.class, classLoader);
                Iterator<AddonLifecycleProvider> iterator = serviceLoader.iterator();
                if (serviceLoader != null && iterator.hasNext() && ClassLoaders.ownsClass((ClassLoader)classLoader, (provider = iterator.next()).getClass())) {
                    if (ControlType.ALL.equals((Object)provider.getControlType())) {
                        result = new AddonLifecycleProviderEntry(dependency, provider);
                    }
                    if (ControlType.DEPENDENTS.equals((Object)provider.getControlType())) {
                        result = new AddonLifecycleProviderEntry(dependency, provider);
                    }
                    if (result != null && iterator.hasNext()) {
                        throw new ContainerException("Expected only one [" + AddonLifecycleProvider.class.getName() + "] but found multiple. Remove all but one redundant container implementations: " + Iterators.asList(serviceLoader));
                    }
                }
                if (result == null) continue;
                results.add(result);
            }
            catch (Throwable e) {
                logger.log(Level.FINEST, "ServiceLoader misbehaved when loading AddonLifecycleProvider instances.", e);
            }
        }
        if (results.size() > 1) {
            throw new ContainerException("Expected only one [" + AddonLifecycleProvider.class.getName() + "] but found multiple. Remove all but one redundant container implementations: " + results);
        }
        return results.isEmpty() ? null : (AddonLifecycleProviderEntry)results.get(0);
    }

    public String toString() {
        return this.addon.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addon == null ? 0 : this.addon.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddonRunnable other = (AddonRunnable)obj;
        return !(this.addon == null ? other.addon != null : !this.addon.equals(other.addon));
    }

    private class AddonLifecycleProviderEntry {
        private final AddonLifecycleProvider provider;
        private final Addon addon;

        public AddonLifecycleProviderEntry(Addon addon, AddonLifecycleProvider value) {
            this.provider = value;
            this.addon = addon;
        }

        public AddonLifecycleProvider getProvider() {
            return this.provider;
        }

        public Addon getAddon() {
            return this.addon;
        }

        public String toString() {
            return "[" + this.addon + " -> " + this.provider + "]";
        }
    }
}

