/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.addons;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.addons.AddonStatus;
import org.jboss.forge.furnace.exception.ContainerException;
import org.jboss.forge.furnace.impl.addons.AddonRegistryImpl;
import org.jboss.forge.furnace.lock.LockManager;
import org.jboss.forge.furnace.lock.LockMode;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.spi.ExportedInstance;
import org.jboss.forge.furnace.spi.ServiceRegistry;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.Sets;

public class ImportedImpl<T>
implements Imported<T> {
    private final Map<T, ExportedInstance<T>> instanceMap = new WeakHashMap<T, ExportedInstance<T>>(new IdentityHashMap());
    private final AddonRegistry addonRegistry;
    private final LockManager lock;
    private Class<T> type;
    private final String typeName;
    private final Set<ExportedInstance<T>> instanceCache = Sets.getConcurrentSet();
    private long version = -1L;

    public ImportedImpl(AddonRegistry addonRegistry, LockManager lock, Class<T> type) {
        this.addonRegistry = addonRegistry;
        this.lock = lock;
        this.type = type;
        this.typeName = type.getName();
    }

    public ImportedImpl(AddonRegistryImpl addonRegistry, LockManager lock, String typeName) {
        this.addonRegistry = addonRegistry;
        this.lock = lock;
        this.typeName = typeName;
    }

    public Iterator<T> iterator() {
        return new ImportedIteratorImpl(this, this.getExportedInstances());
    }

    public T get() {
        if (this.isAmbiguous()) {
            throw new IllegalStateException("Cannot resolve Ambiguous dependencies: " + this.toString());
        }
        ExportedInstance<T> exported = this.getExportedInstance();
        if (exported != null) {
            Object instance = exported.get();
            this.instanceMap.put(instance, exported);
            return (T)instance;
        }
        throw new ContainerException("No services of type [" + this.typeName + "] could be found in any started addons.");
    }

    public void release(T instance) {
        ExportedInstance<T> exported = this.instanceMap.get(instance);
        if (exported != null) {
            this.instanceMap.remove(instance);
            exported.release(instance);
        }
    }

    public T selectExact(Class<T> type) {
        Assert.notNull(type, (String)"Type to select must not be null.");
        Set<ExportedInstance<T>> instances = this.getExportedInstances();
        for (ExportedInstance<T> instance : instances) {
            if (!type.equals(instance.getActualType())) continue;
            Object result = instance.get();
            this.instanceMap.put(result, instance);
            return (T)result;
        }
        throw new ContainerException("No services of type [" + type + "] could be found in any started addons.");
    }

    private ExportedInstance<T> getExportedInstance() {
        return (ExportedInstance)this.lock.performLocked(LockMode.READ, new Callable<ExportedInstance<T>>(){

            @Override
            public ExportedInstance<T> call() throws Exception {
                Iterator iterator = ImportedImpl.this.getExportedInstances().iterator();
                if (iterator.hasNext()) {
                    return (ExportedInstance)iterator.next();
                }
                return null;
            }
        });
    }

    private Set<ExportedInstance<T>> getExportedInstances() {
        return (Set)this.lock.performLocked(LockMode.READ, new Callable<Set<ExportedInstance<T>>>(){

            @Override
            public Set<ExportedInstance<T>> call() throws Exception {
                if (ImportedImpl.this.addonRegistry.getVersion() != ImportedImpl.this.version) {
                    ImportedImpl.this.version = ImportedImpl.this.addonRegistry.getVersion();
                    ImportedImpl.this.instanceCache.clear();
                    for (Addon addon : ImportedImpl.this.addonRegistry.getAddons()) {
                        if (!AddonStatus.STARTED.equals((Object)addon.getStatus())) continue;
                        ServiceRegistry serviceRegistry = addon.getServiceRegistry();
                        if (ImportedImpl.this.type != null) {
                            ImportedImpl.this.instanceCache.addAll(serviceRegistry.getExportedInstances(ImportedImpl.this.type));
                            continue;
                        }
                        ImportedImpl.this.instanceCache.addAll(serviceRegistry.getExportedInstances(ImportedImpl.this.typeName));
                    }
                }
                return ImportedImpl.this.instanceCache;
            }
        });
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[");
        Iterator<ExportedInstance<T>> iterator = this.getExportedInstances().iterator();
        while (iterator.hasNext()) {
            ExportedInstance<T> instance = iterator.next();
            result.append(instance.getActualType().getName()).append(" from addon ");
            result.append(instance.getSourceAddon().getId());
            if (!iterator.hasNext()) continue;
            result.append(",\n");
        }
        result.append("]");
        return result.toString();
    }

    public boolean isUnsatisfied() {
        return this.getExportedInstances().isEmpty();
    }

    public boolean isAmbiguous() {
        return this.getExportedInstances().size() > 1;
    }

    private class ImportedIteratorImpl
    implements Iterator<T> {
        private final ImportedImpl<T> imported;
        private final Iterator<ExportedInstance<T>> iterator;

        public ImportedIteratorImpl(ImportedImpl<T> imported, Set<ExportedInstance<T>> instances) {
            this.imported = imported;
            this.iterator = instances.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            ExportedInstance exported = this.iterator.next();
            Object instance = exported.get();
            this.imported.instanceMap.put(instance, exported);
            return instance;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removal not supported.");
        }
    }
}

