/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects;

import java.util.concurrent.Callable;
import javax.enterprise.event.Observes;
import javax.inject.Singleton;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.logging.console.ConsoleLoggerManager;
import org.jboss.forge.furnace.container.cdi.events.Local;
import org.jboss.forge.furnace.event.PreShutdown;
import org.jboss.forge.furnace.util.ClassLoaders;

@Singleton
class PlexusContainer {
    private DefaultPlexusContainer plexusContainer;

    PlexusContainer() {
    }

    public <T> T lookup(final Class<T> type) {
        try {
            return (T)ClassLoaders.executeIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (Callable)new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return PlexusContainer.this.getPlexusContainer().lookup(type);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Could not look up component of type [" + type.getName() + "]", e);
        }
    }

    public void preShutdown(@Observes @Local PreShutdown event) {
        try {
            ClassLoaders.executeIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (PlexusContainer.this.plexusContainer != null) {
                        PlexusContainer.this.plexusContainer.dispose();
                        PlexusContainer.this.plexusContainer = null;
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Error encountered while disposing PlexusContainer", e);
        }
    }

    private org.codehaus.plexus.PlexusContainer getPlexusContainer() throws Exception {
        if (this.plexusContainer == null) {
            this.plexusContainer = (DefaultPlexusContainer)ClassLoaders.executeIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (Callable)new Callable<DefaultPlexusContainer>(){

                @Override
                public DefaultPlexusContainer call() throws Exception {
                    try {
                        ContainerConfiguration config = new DefaultContainerConfiguration().setAutoWiring(true).setClassPathScanning("index");
                        PlexusContainer.this.plexusContainer = new DefaultPlexusContainer(config);
                        PlexusContainer.this.plexusContainer.setLookupRealm(null);
                        ConsoleLoggerManager loggerManager = new ConsoleLoggerManager();
                        loggerManager.setThreshold("ERROR");
                        PlexusContainer.this.plexusContainer.setLoggerManager((LoggerManager)loggerManager);
                        return PlexusContainer.this.plexusContainer;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not initialize Maven", e);
                    }
                }
            });
        }
        return this.plexusContainer;
    }
}

