/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.graphdb.vertices.StandardVertex;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.wrappers.event.EventVertex;
import com.tinkerpop.frames.FrameInitializer;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.VertexFrame;
import com.tinkerpop.frames.modules.TypeResolver;
import com.tinkerpop.frames.modules.typedgraph.TypeField;
import com.tinkerpop.frames.modules.typedgraph.TypeRegistry;
import com.tinkerpop.frames.modules.typedgraph.TypeValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jboss.windup.graph.model.WindupVertexFrame;

@Singleton
public class GraphTypeManager
implements TypeResolver,
FrameInitializer {
    private Map<String, Class<? extends WindupVertexFrame>> registeredTypes = new HashMap<String, Class<? extends WindupVertexFrame>>();
    private TypeRegistry typeRegistry = new TypeRegistry();

    public Set<Class<? extends WindupVertexFrame>> getRegisteredTypes() {
        return Collections.unmodifiableSet(new HashSet<Class<? extends WindupVertexFrame>>(this.registeredTypes.values()));
    }

    public void addTypeToRegistry(Class<? extends WindupVertexFrame> wvf) {
        TypeValue typeValueAnnotation = wvf.getAnnotation(TypeValue.class);
        if (typeValueAnnotation != null) {
            if (this.registeredTypes.containsKey(typeValueAnnotation.value())) {
                throw new IllegalArgumentException("Type value for model '" + wvf.getCanonicalName() + "' is already registered with model " + this.registeredTypes.get(typeValueAnnotation.value()).getName());
            }
            this.registeredTypes.put(typeValueAnnotation.value(), wvf);
            this.typeRegistry.add(wvf);
        }
    }

    public void addTypeToElement(Class<? extends VertexFrame> kind, Element element) {
        StandardVertex v = GraphTypeManager.asTitanVertex(element);
        Class typeHoldingTypeField = this.typeRegistry.getTypeHoldingTypeField(kind);
        if (typeHoldingTypeField == null) {
            return;
        }
        TypeValue typeValueAnnotation = kind.getAnnotation(TypeValue.class);
        if (typeValueAnnotation == null) {
            return;
        }
        String typeFieldName = typeHoldingTypeField.getAnnotation(TypeField.class).value();
        String typeValue = typeValueAnnotation.value();
        for (TitanProperty existingTypes : v.getProperties(typeFieldName)) {
            if (!existingTypes.getValue().toString().equals(typeValue)) continue;
            return;
        }
        v.addProperty(typeFieldName, (Object)typeValue);
        this.addSuperclassType(kind, element);
    }

    private void addSuperclassType(Class<? extends VertexFrame> kind, Element element) {
        for (Class<?> superInterface : kind.getInterfaces()) {
            if (!WindupVertexFrame.class.isAssignableFrom(superInterface)) continue;
            this.addTypeToElement(superInterface, element);
        }
    }

    public Class<?>[] resolveTypes(Edge e, Class<?> defaultType) {
        return this.resolve((Element)e, defaultType);
    }

    public Class<?>[] resolveTypes(Vertex v, Class<?> defaultType) {
        return this.resolve((Element)v, defaultType);
    }

    public static boolean hasType(Class<? extends WindupVertexFrame> type, WindupVertexFrame frame) {
        return GraphTypeManager.hasType(type, frame.asVertex());
    }

    public static boolean hasType(Class<? extends WindupVertexFrame> type, Vertex v) {
        TypeValue typeValueAnnotation = type.getAnnotation(TypeValue.class);
        if (typeValueAnnotation == null) {
            throw new IllegalArgumentException("Class " + type.getCanonicalName() + " lacks a @TypeValue annotation");
        }
        StandardVertex titanVertex = GraphTypeManager.asTitanVertex((Element)v);
        Iterable vertexTypes = titanVertex.getProperties("w:vertextype");
        for (TitanProperty typeProp : vertexTypes) {
            String typeValue = typeProp.getValue().toString();
            if (!typeValue.equals(typeValueAnnotation.value())) continue;
            return true;
        }
        return false;
    }

    private static StandardVertex asTitanVertex(Element e) {
        if (e instanceof StandardVertex) {
            return (StandardVertex)e;
        }
        if (e instanceof EventVertex) {
            return (StandardVertex)((EventVertex)e).getBaseVertex();
        }
        throw new IllegalArgumentException("Unrecognized element type: " + e.getClass());
    }

    private Class<?>[] resolve(Element e, Class<?> defaultType) {
        Class typeHoldingTypeField = this.typeRegistry.getTypeHoldingTypeField(defaultType);
        if (typeHoldingTypeField != null) {
            String propName = typeHoldingTypeField.getAnnotation(TypeField.class).value();
            StandardVertex v = GraphTypeManager.asTitanVertex(e);
            Iterable valuesAll = v.getProperties(propName);
            if (valuesAll != null) {
                ArrayList<Class<VertexFrame>> resultClasses = new ArrayList<Class<VertexFrame>>();
                for (TitanProperty value : valuesAll) {
                    Class type = this.typeRegistry.getType(typeHoldingTypeField, value.getValue().toString());
                    if (type == null) continue;
                    ListIterator previouslyAddedIterator = resultClasses.listIterator();
                    boolean shouldAdd = true;
                    while (previouslyAddedIterator.hasNext()) {
                        Class previouslyAdded = (Class)previouslyAddedIterator.next();
                        if (previouslyAdded.isAssignableFrom(type)) {
                            previouslyAddedIterator.remove();
                            continue;
                        }
                        if (!type.isAssignableFrom(previouslyAdded)) continue;
                        shouldAdd = false;
                    }
                    if (!shouldAdd) continue;
                    resultClasses.add(type);
                }
                if (!resultClasses.isEmpty()) {
                    resultClasses.add(VertexFrame.class);
                    return resultClasses.toArray(new Class[resultClasses.size()]);
                }
            }
        }
        return new Class[]{defaultType, VertexFrame.class};
    }

    public void initElement(Class<?> kind, FramedGraph<?> framedGraph, Element element) {
        if (VertexFrame.class.isAssignableFrom(kind)) {
            this.addTypeToElement(kind, element);
        }
    }
}

