/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.tinkerpop.blueprints.Element;
import com.tinkerpop.frames.FrameInitializer;
import com.tinkerpop.frames.FramedGraphConfiguration;
import com.tinkerpop.frames.VertexFrame;
import com.tinkerpop.frames.modules.AbstractModule;
import com.tinkerpop.frames.modules.Module;
import com.tinkerpop.frames.modules.TypeResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.windup.graph.GraphTypeManager;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.util.WindupPathUtil;
import org.jboss.windup.util.furnace.FurnaceClasspathScanner;

@Singleton
public class GraphTypeRegistry {
    private static final Logger LOG = Logger.getLogger(GraphTypeRegistry.class.getName());
    @Inject
    private FurnaceClasspathScanner scanner;
    @Inject
    private GraphTypeManager graphTypeManager;

    public void addTypeToElement(Class<? extends VertexFrame> kind, Element element) {
        this.graphTypeManager.addTypeToElement(kind, element);
    }

    @PostConstruct
    public void init() {
        Predicate<String> modelClassFilter = new Predicate<String>(){
            Set<String> skipPackages = new HashSet<String>();
            {
                this.skipPackages.add("org.dom4j.");
                this.skipPackages.add("groovy.model.");
                this.skipPackages.add("com.sleepycat.persist.");
                this.skipPackages.add("org.apache.lucene.");
                this.skipPackages.add("org.openrdf.model.");
                this.skipPackages.add("org.apache.bcel.");
                this.skipPackages.add("org.eclipse.jdt.");
                this.skipPackages.add("javax.");
                this.skipPackages.add("org.jboss.weld.");
                this.skipPackages.add("freemarker.");
            }

            public boolean accept(String path) {
                if (!path.endsWith("Model.class")) {
                    return false;
                }
                String clsName = WindupPathUtil.classFilePathToClassname((String)path);
                for (String pkg : this.skipPackages) {
                    if (!clsName.startsWith(pkg)) continue;
                    return false;
                }
                return true;
            }
        };
        LOG.info("Looking for *Model classes...");
        List classes = this.scanner.scanClasses((Predicate)modelClassFilter);
        for (Class clazz : classes) {
            if (WindupVertexFrame.class.isAssignableFrom(clazz)) {
                LOG.fine("    Found: " + clazz);
                Class wvf = clazz;
                this.graphTypeManager.addTypeToRegistry(wvf);
                continue;
            }
            LOG.fine("    Not adding [" + clazz.getCanonicalName() + "] to GraphTypeRegistry");
        }
        this.logLoadedModelTypes(this.graphTypeManager.getRegisteredTypes());
    }

    private void logLoadedModelTypes(Set<Class<? extends WindupVertexFrame>> types) {
        ArrayList<Class<? extends WindupVertexFrame>> list = new ArrayList<Class<? extends WindupVertexFrame>>(types);
        Collections.sort(list, new Comparator<Class<? extends WindupVertexFrame>>(){

            @Override
            public int compare(Class<? extends WindupVertexFrame> left, Class<? extends WindupVertexFrame> right) {
                if (left == right) {
                    return 0;
                }
                if (left == null) {
                    return 1;
                }
                if (right == null) {
                    return -1;
                }
                return left.getCanonicalName().compareTo(right.getCanonicalName());
            }
        });
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            Class type = (Class)list.get(i);
            result.append(type.getName());
            if (i + 1 >= list.size()) continue;
            result.append(OperatingSystemUtils.getLineSeparator());
        }
        LOG.info("Loaded [" + list.size() + "] WindupVertexFrame sub-types [" + OperatingSystemUtils.getLineSeparator() + result.toString() + OperatingSystemUtils.getLineSeparator() + "]");
    }

    public Module build() {
        return new AbstractModule(){

            public void doConfigure(FramedGraphConfiguration config) {
                config.addTypeResolver((TypeResolver)GraphTypeRegistry.this.graphTypeManager);
                config.addFrameInitializer((FrameInitializer)GraphTypeRegistry.this.graphTypeManager);
            }
        };
    }
}

