/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.locking;

import com.google.common.collect.MapMaker;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.util.KeyColumn;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class LockerState<S> {
    private final ConcurrentMap<StoreTransaction, Map<KeyColumn, S>> locks;

    public LockerState() {
        this(new MapMaker().concurrencyLevel(8).weakKeys().makeMap());
    }

    public LockerState(ConcurrentMap<StoreTransaction, Map<KeyColumn, S>> locks) {
        this.locks = locks;
    }

    public boolean has(StoreTransaction tx, KeyColumn kc) {
        return this.getLocksForTx(tx).containsKey(kc);
    }

    public void take(StoreTransaction tx, KeyColumn kc, S ls) {
        this.getLocksForTx(tx).put(kc, ls);
    }

    public void release(StoreTransaction tx, KeyColumn kc) {
        this.getLocksForTx(tx).remove(kc);
    }

    public Map<KeyColumn, S> getLocksForTx(StoreTransaction tx) {
        Map x;
        Map m = (HashMap)this.locks.get(tx);
        if (null == m && null != (x = (Map)this.locks.putIfAbsent(tx, m = new HashMap()))) {
            m = x;
        }
        return m;
    }
}

