/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.reader;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.reader.AeshInputStream;
import org.jboss.aesh.util.LoggerUtil;

public class ConsoleInputSession {
    private final InputStream consoleStream;
    private final AeshInputStream aeshInputStream;
    private final ExecutorService executorService;
    private final ArrayBlockingQueue<String> blockingQueue = new ArrayBlockingQueue(1000);
    private static final Logger LOGGER = LoggerUtil.getLogger(ConsoleInputSession.class.getName());

    public ConsoleInputSession(InputStream consoleStream) {
        this.consoleStream = consoleStream;
        this.executorService = Config.isOSPOSIXCompatible() ? Executors.newSingleThreadExecutor() : Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                thread.setDaemon(true);
                return thread;
            }
        });
        this.aeshInputStream = new AeshInputStream(this.blockingQueue);
        this.startReader();
    }

    private void startReader() {
        Runnable reader = new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] bBuf = new byte[1024];
                    if (Config.isOSPOSIXCompatible()) {
                        while (!ConsoleInputSession.this.executorService.isShutdown()) {
                            int read = ConsoleInputSession.this.consoleStream.available();
                            if (read > 0) {
                                ConsoleInputSession.this.consoleStream.read(bBuf, 0, read);
                                ConsoleInputSession.this.blockingQueue.put(new String(bBuf, 0, read));
                            } else if (read < 0) {
                                ConsoleInputSession.this.stop();
                            }
                            Thread.sleep(10L);
                        }
                    } else {
                        while (!ConsoleInputSession.this.executorService.isShutdown()) {
                            int read = ConsoleInputSession.this.consoleStream.read(bBuf);
                            if (read > 0) {
                                ConsoleInputSession.this.blockingQueue.put(new String(bBuf, 0, read));
                            } else if (read < 0) {
                                ConsoleInputSession.this.stop();
                            }
                            Thread.sleep(10L);
                        }
                    }
                }
                catch (RuntimeException e) {
                    if (!ConsoleInputSession.this.executorService.isShutdown()) {
                        ConsoleInputSession.this.executorService.shutdown();
                        throw e;
                    }
                }
                catch (Exception e) {
                    if (!ConsoleInputSession.this.executorService.isShutdown()) {
                        ConsoleInputSession.this.executorService.shutdown();
                    }
                    try {
                        ConsoleInputSession.this.stop();
                    }
                    catch (IOException | InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        };
        this.executorService.execute(reader);
    }

    public void stop() throws IOException, InterruptedException {
        if (!this.executorService.isShutdown()) {
            this.consoleStream.close();
            this.executorService.shutdown();
            this.aeshInputStream.close();
            LOGGER.info("input stream is closed, readers finished...");
        }
    }

    public AeshInputStream getExternalInputStream() {
        return this.aeshInputStream;
    }
}

