/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal;

import org.jboss.aesh.terminal.CursorPosition;

public class TerminalSize {
    private int height;
    private int width;

    public TerminalSize(int height, int width) {
        this.setHeight(height);
        this.setWidth(width);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        if (width < 1) {
            throw new IllegalArgumentException("Terminal width cannot be less than 1");
        }
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        if (height < 1) {
            throw new IllegalArgumentException("Terminal height cannot be less than 1");
        }
        this.height = height;
    }

    public boolean isPositionWithinSize(CursorPosition pos) {
        return pos.getRow() > -1 && pos.getColumn() > -1 && pos.getRow() < this.height && pos.getColumn() < this.width;
    }

    public String toString() {
        return "TerminalSize{height=" + this.height + ", width=" + this.width + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TerminalSize)) {
            return false;
        }
        TerminalSize that = (TerminalSize)o;
        return this.height == that.height && this.width == that.width;
    }

    public int hashCode() {
        int result = this.height;
        result = 31 * result + this.width;
        return result;
    }
}

