/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.parser.java.ui;

import java.io.File;
import javax.inject.Inject;
import org.jboss.forge.addon.configuration.Configuration;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.util.Strings;

public class SetDefaultFormatterCommand
extends AbstractUICommand {
    @Inject
    @WithAttributes(label="Formatter Name", description="The formatter name specified in the Eclipse formatter XML file")
    private UIInput<String> formatterName;
    @Inject
    @WithAttributes(label="Formatter Path", description="An Eclipse formatter XML file with the profile to use", required=true)
    private UIInput<FileResource<?>> formatterPath;
    @Inject
    private Configuration configuration;
    @Inject
    private ResourceFactory resourceFactory;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Java: Set Default Formatter").description("Sets the default formatter for the Java resources").category(Categories.create((String[])new String[]{"Java"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        String path;
        String profileName = this.configuration.getString("org.jboss.forge.addon.parser.java.formatter_profile_name");
        if (!Strings.isNullOrEmpty((String)profileName)) {
            this.formatterName.setDefaultValue((Object)profileName);
        }
        if (!Strings.isNullOrEmpty((String)(path = this.configuration.getString("org.jboss.forge.addon.parser.java.formatter_profile_path")))) {
            FileResource resource = (FileResource)this.resourceFactory.create(FileResource.class, (Object)new File(path));
            this.formatterPath.setDefaultValue((Object)resource);
        }
        builder.add(this.formatterName).add(this.formatterPath);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        String name = (String)this.formatterName.getValue();
        FileResource path = (FileResource)this.formatterPath.getValue();
        if (!Strings.isNullOrEmpty((String)name)) {
            this.configuration.setProperty("org.jboss.forge.addon.parser.java.formatter_profile_name", (Object)name);
        } else {
            this.configuration.clearProperty("org.jboss.forge.addon.parser.java.formatter_profile_name");
        }
        this.configuration.setProperty("org.jboss.forge.addon.parser.java.formatter_profile_path", (Object)path.getFullyQualifiedName());
        return Results.success();
    }
}

