/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.WindupRuleProvider;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.Rule;

public class WindupRuleMetadata {
    private final List<WindupRuleProvider> providers = new ArrayList<WindupRuleProvider>();
    private final IdentityHashMap<WindupRuleProvider, List<Rule>> providersToRules = new IdentityHashMap();
    private Configuration configuration;

    public static WindupRuleMetadata instance(GraphRewrite event) {
        WindupRuleMetadata instance = (WindupRuleMetadata)event.getRewriteContext().get(WindupRuleMetadata.class);
        return instance;
    }

    public void setProviders(List<WindupRuleProvider> providers) {
        this.providers.clear();
        this.providers.addAll(providers);
    }

    public List<WindupRuleProvider> getProviders() {
        return Collections.unmodifiableList(this.providers);
    }

    public void setRules(WindupRuleProvider provider, List<Rule> rules) {
        this.providersToRules.put(provider, rules);
    }

    public List<Rule> getRules(WindupRuleProvider provider) {
        List<Rule> rules = this.providersToRules.get(provider);
        if (rules == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(rules);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

