/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.msgpack.MessagePackable;
import org.msgpack.MessageTypeException;
import org.msgpack.template.AnyTemplate;
import org.msgpack.template.BigDecimalTemplate;
import org.msgpack.template.BigIntegerTemplate;
import org.msgpack.template.BooleanArrayTemplate;
import org.msgpack.template.BooleanTemplate;
import org.msgpack.template.ByteArrayTemplate;
import org.msgpack.template.ByteBufferTemplate;
import org.msgpack.template.ByteTemplate;
import org.msgpack.template.CharacterTemplate;
import org.msgpack.template.CollectionTemplate;
import org.msgpack.template.DateTemplate;
import org.msgpack.template.DoubleArrayTemplate;
import org.msgpack.template.DoubleTemplate;
import org.msgpack.template.FieldList;
import org.msgpack.template.FloatArrayTemplate;
import org.msgpack.template.FloatTemplate;
import org.msgpack.template.GenericCollectionTemplate;
import org.msgpack.template.GenericMapTemplate;
import org.msgpack.template.GenericTemplate;
import org.msgpack.template.IntegerArrayTemplate;
import org.msgpack.template.IntegerTemplate;
import org.msgpack.template.ListTemplate;
import org.msgpack.template.LongArrayTemplate;
import org.msgpack.template.LongTemplate;
import org.msgpack.template.MapTemplate;
import org.msgpack.template.MessagePackableTemplate;
import org.msgpack.template.ShortArrayTemplate;
import org.msgpack.template.ShortTemplate;
import org.msgpack.template.StringTemplate;
import org.msgpack.template.Template;
import org.msgpack.template.TemplateReference;
import org.msgpack.template.ValueTemplate;
import org.msgpack.template.builder.TemplateBuilder;
import org.msgpack.template.builder.TemplateBuilderChain;
import org.msgpack.type.Value;

public class TemplateRegistry {
    private TemplateRegistry parent = null;
    private TemplateBuilderChain chain;
    Map<Type, Template<Type>> cache;
    private Map<Type, GenericTemplate> genericCache;

    private TemplateRegistry() {
        this.parent = null;
        this.chain = this.createTemplateBuilderChain();
        this.genericCache = new HashMap<Type, GenericTemplate>();
        this.cache = new HashMap<Type, Template<Type>>();
        this.registerTemplates();
        this.cache = Collections.unmodifiableMap(this.cache);
    }

    public TemplateRegistry(TemplateRegistry registry) {
        this.parent = registry != null ? registry : new TemplateRegistry();
        this.chain = this.createTemplateBuilderChain();
        this.cache = new HashMap<Type, Template<Type>>();
        this.genericCache = new HashMap<Type, GenericTemplate>();
        this.registerTemplatesWhichRefersRegistry();
    }

    protected TemplateBuilderChain createTemplateBuilderChain() {
        return new TemplateBuilderChain(this);
    }

    public void setClassLoader(ClassLoader cl) {
        this.chain = new TemplateBuilderChain(this, cl);
    }

    private void registerTemplates() {
        this.register(Boolean.TYPE, BooleanTemplate.getInstance());
        this.register((Type)((Object)Boolean.class), BooleanTemplate.getInstance());
        this.register(Byte.TYPE, ByteTemplate.getInstance());
        this.register((Type)((Object)Byte.class), ByteTemplate.getInstance());
        this.register(Short.TYPE, ShortTemplate.getInstance());
        this.register((Type)((Object)Short.class), ShortTemplate.getInstance());
        this.register(Integer.TYPE, IntegerTemplate.getInstance());
        this.register((Type)((Object)Integer.class), IntegerTemplate.getInstance());
        this.register(Long.TYPE, LongTemplate.getInstance());
        this.register((Type)((Object)Long.class), LongTemplate.getInstance());
        this.register(Float.TYPE, FloatTemplate.getInstance());
        this.register((Type)((Object)Float.class), FloatTemplate.getInstance());
        this.register(Double.TYPE, DoubleTemplate.getInstance());
        this.register((Type)((Object)Double.class), DoubleTemplate.getInstance());
        this.register((Type)((Object)BigInteger.class), BigIntegerTemplate.getInstance());
        this.register(Character.TYPE, CharacterTemplate.getInstance());
        this.register((Type)((Object)Character.class), CharacterTemplate.getInstance());
        this.register((Type)((Object)boolean[].class), BooleanArrayTemplate.getInstance());
        this.register((Type)((Object)short[].class), ShortArrayTemplate.getInstance());
        this.register((Type)((Object)int[].class), IntegerArrayTemplate.getInstance());
        this.register((Type)((Object)long[].class), LongArrayTemplate.getInstance());
        this.register((Type)((Object)float[].class), FloatArrayTemplate.getInstance());
        this.register((Type)((Object)double[].class), DoubleArrayTemplate.getInstance());
        this.register((Type)((Object)String.class), StringTemplate.getInstance());
        this.register((Type)((Object)byte[].class), ByteArrayTemplate.getInstance());
        this.register((Type)((Object)ByteBuffer.class), ByteBufferTemplate.getInstance());
        this.register((Type)((Object)Value.class), ValueTemplate.getInstance());
        this.register((Type)((Object)BigDecimal.class), BigDecimalTemplate.getInstance());
        this.register((Type)((Object)Date.class), DateTemplate.getInstance());
        this.registerTemplatesWhichRefersRegistry();
    }

    protected void registerTemplatesWhichRefersRegistry() {
        AnyTemplate anyTemplate = new AnyTemplate(this);
        this.register((Type)((Object)List.class), new ListTemplate(anyTemplate));
        this.register((Type)((Object)Collection.class), new CollectionTemplate(anyTemplate));
        this.register((Type)((Object)Map.class), new MapTemplate(anyTemplate, anyTemplate));
        this.registerGeneric((Type)((Object)List.class), new GenericCollectionTemplate(this, ListTemplate.class));
        this.registerGeneric((Type)((Object)Collection.class), new GenericCollectionTemplate(this, CollectionTemplate.class));
        this.registerGeneric((Type)((Object)Map.class), new GenericMapTemplate(this, MapTemplate.class));
    }

    public void register(Class<?> targetClass) {
        this.buildAndRegister(null, targetClass, false, null);
    }

    public void register(Class<?> targetClass, FieldList flist) {
        if (flist == null) {
            throw new NullPointerException("FieldList object is null");
        }
        this.buildAndRegister(null, targetClass, false, flist);
    }

    public synchronized void register(Type targetType, Template tmpl) {
        if (tmpl == null) {
            throw new NullPointerException("Template object is null");
        }
        if (targetType instanceof ParameterizedType) {
            this.cache.put(((ParameterizedType)targetType).getRawType(), tmpl);
        } else {
            this.cache.put(targetType, tmpl);
        }
    }

    public synchronized void registerGeneric(Type targetType, GenericTemplate tmpl) {
        if (targetType instanceof ParameterizedType) {
            this.genericCache.put(((ParameterizedType)targetType).getRawType(), tmpl);
        } else {
            this.genericCache.put(targetType, tmpl);
        }
    }

    public synchronized boolean unregister(Type targetType) {
        Template<Type> tmpl = this.cache.remove(targetType);
        return tmpl != null;
    }

    public synchronized void unregister() {
        this.cache.clear();
    }

    public synchronized Template lookup(Type targetType) {
        Template<MessagePackable> tmpl = this.lookupGenericType(targetType);
        if (tmpl != null) {
            return tmpl;
        }
        tmpl = this.lookupCache(targetType);
        if (tmpl != null) {
            return tmpl;
        }
        Class targetClass = (Class)targetType;
        if (MessagePackable.class.isAssignableFrom(targetClass)) {
            tmpl = new MessagePackableTemplate(targetClass);
            this.register((Type)targetClass, tmpl);
            return tmpl;
        }
        tmpl = this.lookupAfterBuilding(targetClass);
        if (tmpl != null) {
            return tmpl;
        }
        tmpl = this.lookupInterfaceTypes(targetClass);
        if (tmpl != null) {
            return tmpl;
        }
        tmpl = this.lookupSuperclasses(targetClass);
        if (tmpl != null) {
            return tmpl;
        }
        tmpl = this.lookupSuperclassInterfaceTypes(targetClass);
        if (tmpl != null) {
            return tmpl;
        }
        throw new MessageTypeException("Cannot find template for " + targetClass + " class.  " + "Try to add @Message annotation to the class or call MessagePack.register(Type).");
    }

    private Template<Type> lookupGenericType(Type targetType) {
        Template tmpl = null;
        if (targetType instanceof ParameterizedType) {
            ParameterizedType paramedType = (ParameterizedType)targetType;
            tmpl = this.lookupGenericTypeImpl(paramedType);
            if (tmpl != null) {
                return tmpl;
            }
            try {
                tmpl = this.parent.lookupGenericTypeImpl(paramedType);
                if (tmpl != null) {
                    return tmpl;
                }
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            targetType = paramedType.getRawType();
        }
        return tmpl;
    }

    private Template lookupGenericTypeImpl(ParameterizedType targetType) {
        Type rawType = targetType.getRawType();
        GenericTemplate tmpl = this.genericCache.get(rawType);
        if (tmpl == null) {
            return null;
        }
        Type[] types = targetType.getActualTypeArguments();
        Template[] tmpls = new Template[types.length];
        for (int i = 0; i < types.length; ++i) {
            tmpls[i] = this.lookup(types[i]);
        }
        return tmpl.build(tmpls);
    }

    private Template<Type> lookupCache(Type targetType) {
        Template<Type> tmpl = this.cache.get(targetType);
        if (tmpl != null) {
            return tmpl;
        }
        try {
            tmpl = this.parent.lookupCache(targetType);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return tmpl;
    }

    private <T> Template<T> lookupAfterBuilding(Class<T> targetClass) {
        TemplateBuilder builder = this.chain.select(targetClass, true);
        Template tmpl = null;
        if (builder != null) {
            tmpl = this.chain.getForceBuilder().loadTemplate(targetClass);
            if (tmpl != null) {
                this.register(targetClass, tmpl);
                return tmpl;
            }
            tmpl = this.buildAndRegister(builder, targetClass, true, null);
        }
        return tmpl;
    }

    private <T> Template<T> lookupInterfaceTypes(Class<T> targetClass) {
        Class<?>[] infTypes = targetClass.getInterfaces();
        Template<Type> tmpl = null;
        for (Class<?> infType : infTypes) {
            tmpl = this.cache.get(infType);
            if (tmpl != null) {
                this.register(targetClass, tmpl);
                return tmpl;
            }
            try {
                tmpl = this.parent.lookupCache(infType);
                if (tmpl == null) continue;
                this.register(targetClass, tmpl);
                return tmpl;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        return tmpl;
    }

    private <T> Template<T> lookupSuperclasses(Class<T> targetClass) {
        Class<T> superClass;
        Template<Type> tmpl = null;
        if (superClass != null) {
            for (superClass = targetClass.getSuperclass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
                tmpl = this.cache.get(superClass);
                if (tmpl != null) {
                    this.register(targetClass, tmpl);
                    return tmpl;
                }
                try {
                    tmpl = this.parent.lookupCache(superClass);
                    if (tmpl != null) {
                        this.register(targetClass, tmpl);
                        return tmpl;
                    }
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        return tmpl;
    }

    private <T> Template<T> lookupSuperclassInterfaceTypes(Class<T> targetClass) {
        Class<T> superClass;
        Template<Object> tmpl = null;
        if (superClass != null) {
            for (superClass = targetClass.getSuperclass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
                tmpl = this.lookupInterfaceTypes(superClass);
                if (tmpl != null) {
                    this.register(targetClass, tmpl);
                    return tmpl;
                }
                try {
                    tmpl = this.parent.lookupCache(superClass);
                    if (tmpl != null) {
                        this.register(targetClass, tmpl);
                        return tmpl;
                    }
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        return tmpl;
    }

    private synchronized Template buildAndRegister(TemplateBuilder builder, Class targetClass, boolean hasAnnotation, FieldList flist) {
        Template newTmpl = null;
        Template<Type> oldTmpl = null;
        try {
            if (this.cache.containsKey(targetClass)) {
                oldTmpl = this.cache.get(targetClass);
            }
            newTmpl = new TemplateReference(this, targetClass);
            this.cache.put(targetClass, newTmpl);
            if (builder == null) {
                builder = this.chain.select(targetClass, hasAnnotation);
            }
            Template template = newTmpl = flist != null ? builder.buildTemplate(targetClass, flist) : builder.buildTemplate(targetClass);
            return template;
        }
        catch (Exception e) {
            if (oldTmpl != null) {
                this.cache.put(targetClass, oldTmpl);
            } else {
                this.cache.remove(targetClass);
            }
            newTmpl = null;
            if (e instanceof MessageTypeException) {
                throw (MessageTypeException)e;
            }
            throw new MessageTypeException(e);
        }
        finally {
            if (newTmpl != null) {
                this.cache.put(targetClass, newTmpl);
            }
        }
    }
}

