/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.resource;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jboss.forge.addon.facets.AbstractFaceted;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFacet;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.ResourceFilter;
import org.jboss.forge.addon.resource.util.ResourcePathResolver;
import org.jboss.forge.furnace.util.Streams;

public abstract class AbstractResource<T>
extends AbstractFaceted<ResourceFacet>
implements Resource<T> {
    private final ResourceFactory resourceFactory;
    private Resource<?> parent;

    protected AbstractResource(ResourceFactory factory, Resource<?> parent) {
        if (factory == null) {
            throw new IllegalArgumentException("ResourceFactory must not be null.");
        }
        this.resourceFactory = factory;
        this.parent = parent;
    }

    @Override
    public ResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getParent() != null ? this.getParent().getFullyQualifiedName() + "/" + this.getName() : this.getName();
    }

    @Override
    public Resource<?> getParent() {
        return this.parent;
    }

    protected void setParent(Resource<?> parent) {
        this.parent = parent;
    }

    @Override
    public <R extends Resource<?>> R reify(Class<R> type) {
        if (type.isInstance(this)) {
            return (R)((Resource)type.cast(this));
        }
        return null;
    }

    protected abstract List<Resource<?>> doListResources();

    @Override
    public synchronized List<Resource<?>> listResources() {
        List<Resource<?>> resources = this.doListResources();
        Collections.sort(resources, new FQNResourceComparator());
        return resources;
    }

    @Override
    public synchronized List<Resource<?>> listResources(ResourceFilter filter) {
        ArrayList result = new ArrayList();
        for (Resource<?> resource : this.doListResources()) {
            if (!filter.accept(resource)) continue;
            result.add(resource);
        }
        Collections.sort(result, new FQNResourceComparator());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getContents() {
        InputStream stream = this.getResourceInputStream();
        try {
            String string = Streams.toString((InputStream)stream);
            return string;
        }
        finally {
            Streams.closeQuietly((Closeable)stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getContents(Charset charset) {
        InputStream stream = this.getResourceInputStream();
        try {
            String string = Streams.toString((InputStream)stream, (Charset)charset);
            return string;
        }
        finally {
            Streams.closeQuietly((Closeable)stream);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Resource) {
            return ((Resource)obj).getFullyQualifiedName().equals(this.getFullyQualifiedName());
        }
        return false;
    }

    public int hashCode() {
        return this.getFullyQualifiedName().hashCode();
    }

    public <F extends ResourceFacet> boolean supports(F facet) {
        return facet != null;
    }

    @Override
    public List<Resource<?>> resolveChildren(String path) {
        ResourcePathResolver resolver = new ResourcePathResolver(this.getResourceFactory(), this, path);
        return resolver.resolve();
    }

    private static class FQNResourceComparator
    implements Comparator<Resource<?>> {
        private FQNResourceComparator() {
        }

        @Override
        public int compare(Resource<?> left, Resource<?> right) {
            return left.getFullyQualifiedName().compareTo(right.getFullyQualifiedName());
        }
    }
}

