/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster;

import com.codahale.metrics.annotation.Timed;
import com.tinkerpop.blueprints.impls.sail.SailGraph;
import com.tinkerpop.rexster.AbstractSubResource;
import com.tinkerpop.rexster.RexsterApplicationGraph;
import com.tinkerpop.rexster.extension.HttpMethod;
import com.tinkerpop.rexster.server.RexsterApplication;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

@Path(value="/graphs/{graphname}/prefixes")
public class PrefixResource
extends AbstractSubResource {
    private static Logger logger = Logger.getLogger(PrefixResource.class);

    public PrefixResource() {
        super(null);
    }

    public PrefixResource(UriInfo ui, HttpServletRequest req, RexsterApplication ra) {
        super(ra);
        this.httpServletRequest = req;
        this.uriInfo = ui;
    }

    @OPTIONS
    public Response optionsPrefixes() {
        return this.buildOptionsResponse(HttpMethod.GET.toString(), HttpMethod.POST.toString());
    }

    @GET
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.prefixes.collection.get", absolute=true)
    public Response getPrefixes(@PathParam(value="graphname") String graphName) {
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        try {
            SailGraph graph = (SailGraph)rag.getUnwrappedGraph();
            JSONArray results = new JSONArray();
            for (Map.Entry entry : graph.getNamespaces().entrySet()) {
                JSONObject result = new JSONObject();
                result.put((String)entry.getKey(), entry.getValue());
                results.put((Object)result);
            }
            this.resultObject.put("results", (Object)results);
            this.resultObject.put("queryTime", this.sh.stopWatch());
            Response response = Response.ok((Object)this.resultObject).build();
            return response;
        }
        catch (JSONException ex) {
            logger.error((Object)ex);
            JSONObject error = this.generateErrorObjectJsonFail(ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        catch (RuntimeException re) {
            logger.error((Object)re);
            JSONObject error = this.generateErrorObject(re.getMessage(), re);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        finally {
            rag.tryCommit();
        }
    }

    @OPTIONS
    @Path(value="/{prefix}")
    public Response optionsSinglePrefix() {
        return this.buildOptionsResponse(HttpMethod.GET.toString(), HttpMethod.DELETE.toString());
    }

    @GET
    @Path(value="/{prefix}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.prefixes.object.get", absolute=true)
    public Response getSinglePrefix(@PathParam(value="graphname") String graphName, @PathParam(value="prefix") String prefix) {
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        try {
            SailGraph graph = (SailGraph)rag.getUnwrappedGraph();
            this.resultObject.put("results", graph.getNamespaces().get(prefix));
            this.resultObject.put("queryTime", this.sh.stopWatch());
            Response response = Response.ok((Object)this.resultObject).build();
            return response;
        }
        catch (JSONException ex) {
            logger.error((Object)ex);
            JSONObject error = this.generateErrorObjectJsonFail(ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        catch (RuntimeException re) {
            logger.error((Object)re);
            JSONObject error = this.generateErrorObject(re.getMessage(), re);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        finally {
            rag.tryCommit();
        }
    }

    @DELETE
    @Path(value="/{prefix}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.prefixes.object.delete", absolute=true)
    public Response deleteSinglePrefix(@PathParam(value="graphname") String graphName, @PathParam(value="prefix") String prefix) {
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        try {
            SailGraph graph = (SailGraph)rag.getUnwrappedGraph();
            graph.removeNamespace(prefix);
            rag.tryCommit();
            this.resultObject.put("queryTime", this.sh.stopWatch());
            return Response.ok((Object)this.resultObject).build();
        }
        catch (JSONException ex) {
            logger.error((Object)ex);
            rag.tryRollback();
            JSONObject error = this.generateErrorObjectJsonFail(ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        catch (RuntimeException re) {
            logger.error((Object)re);
            rag.tryRollback();
            JSONObject error = this.generateErrorObject(re.getMessage(), re);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
    }

    @POST
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Consumes(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.prefixes.object.post", absolute=true)
    public Response postSinglePrefix(@PathParam(value="graphname") String graphName, JSONObject json) {
        this.setRequestObject(json);
        return this.postSinglePrefix(graphName);
    }

    @POST
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.prefixes.object.post", absolute=true)
    public Response postSinglePrefix(@PathParam(value="graphname") String graphName) {
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        JSONObject reqObject = this.getRequestObject();
        if (!reqObject.has("prefix") || !reqObject.has("namespace")) {
            JSONObject error = this.generateErrorObject("Parameters 'prefix' and 'namespace' required");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build());
        }
        try {
            SailGraph graph = (SailGraph)rag.getUnwrappedGraph();
            graph.addNamespace(reqObject.optString("prefix"), reqObject.optString("namespace"));
            rag.tryCommit();
            this.resultObject.put("queryTime", this.sh.stopWatch());
            return Response.ok((Object)this.resultObject).build();
        }
        catch (JSONException ex) {
            logger.error((Object)ex);
            rag.tryRollback();
            JSONObject error = this.generateErrorObjectJsonFail(ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        catch (RuntimeException re) {
            logger.error((Object)re);
            rag.tryRollback();
            JSONObject error = this.generateErrorObject(re.getMessage(), re);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
    }
}

