/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.config;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.impls.tg.TinkerGraph;
import com.tinkerpop.rexster.config.GraphConfiguration;
import com.tinkerpop.rexster.config.GraphConfigurationContext;
import com.tinkerpop.rexster.config.GraphConfigurationException;
import com.tinkerpop.rexster.util.MockTinkerTransactionalGraph;
import org.apache.commons.configuration.ConversionException;

public class TinkerGraphGraphConfiguration
implements GraphConfiguration {
    public Graph configureGraphInstance(GraphConfigurationContext context) throws GraphConfigurationException {
        String fileType;
        boolean mockTx;
        String graphFile = context.getProperties().getString("graph-location", null);
        try {
            mockTx = context.getProperties().getBoolean("graph-mock-tx", false);
        }
        catch (ConversionException ce) {
            throw new GraphConfigurationException((Throwable)ce);
        }
        try {
            fileType = context.getProperties().getString("graph-storage", "");
        }
        catch (IllegalArgumentException iae) {
            fileType = "";
        }
        try {
            if (graphFile == null || graphFile.length() == 0) {
                return mockTx ? new MockTinkerTransactionalGraph() : new TinkerGraph();
            }
            return mockTx ? new MockTinkerTransactionalGraph(graphFile, this.getFileType(fileType)) : new TinkerGraph(graphFile, this.getFileType(fileType));
        }
        catch (Exception ex) {
            throw new GraphConfigurationException((Throwable)ex);
        }
    }

    private TinkerGraph.FileType getFileType(String fileType) {
        String fileTypeLower = fileType.toLowerCase();
        if (fileTypeLower.equals("graphson")) {
            return TinkerGraph.FileType.GRAPHSON;
        }
        if (fileTypeLower.equals("graphml")) {
            return TinkerGraph.FileType.GRAPHML;
        }
        if (fileTypeLower.equals("gml")) {
            return TinkerGraph.FileType.GML;
        }
        return TinkerGraph.FileType.JAVA;
    }
}

