/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.gremlin;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONMode;
import com.tinkerpop.pipes.util.structures.Pair;
import com.tinkerpop.rexster.RexsterApplicationGraph;
import com.tinkerpop.rexster.RexsterResourceContext;
import com.tinkerpop.rexster.extension.AbstractRexsterExtension;
import com.tinkerpop.rexster.extension.ExtensionApi;
import com.tinkerpop.rexster.extension.ExtensionConfiguration;
import com.tinkerpop.rexster.extension.ExtensionDefinition;
import com.tinkerpop.rexster.extension.ExtensionDescriptor;
import com.tinkerpop.rexster.extension.ExtensionMethod;
import com.tinkerpop.rexster.extension.ExtensionNaming;
import com.tinkerpop.rexster.extension.ExtensionPoint;
import com.tinkerpop.rexster.extension.ExtensionRequestParameter;
import com.tinkerpop.rexster.extension.ExtensionResponse;
import com.tinkerpop.rexster.extension.HttpMethod;
import com.tinkerpop.rexster.extension.RexsterContext;
import com.tinkerpop.rexster.gremlin.converter.JSONResultConverter;
import com.tinkerpop.rexster.protocol.EngineController;
import com.tinkerpop.rexster.protocol.EngineHolder;
import com.tinkerpop.rexster.util.ElementHelper;
import com.tinkerpop.rexster.util.RequestObjectHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

@ExtensionNaming(namespace="tp", name="gremlin")
public class GremlinExtension
extends AbstractRexsterExtension {
    protected static final Logger logger = Logger.getLogger(GremlinExtension.class);
    public static final String EXTENSION_NAMESPACE = "tp";
    public static final String EXTENSION_NAME = "gremlin";
    private static final ConcurrentMap<String, String> cachedScripts = new ConcurrentHashMap<String, String>();
    private static final String GRAPH_VARIABLE = "g";
    private static final String VERTEX_VARIABLE = "v";
    private static final String EDGE_VARIABLE = "e";
    private static final String WILDCARD = "*";
    private static final String SCRIPT = "script";
    private static final String LANGUAGE = "language";
    private static final String PARAMS = "params";
    private static final String LOAD = "load";
    private static final String RETURN_TOTAL = "returnTotal";
    private static final String API_SHOW_TYPES = "displays the properties of the elements with their native data type (default is false)";
    private static final String API_SCRIPT = "the Gremlin script to be evaluated";
    private static final String API_RETURN_KEYS = "an array of element property keys to return (default is to return all element properties)";
    private static final String API_START_OFFSET = "start index for a paged set of data to be returned";
    private static final String API_END_OFFSET = "end index for a paged set of data to be returned";
    private static final String API_LANGUAGE = "the gremlin language flavor to use (default is groovy)";
    private static final String API_PARAMS = "a map of parameters to bind to the script engine";
    private static final String API_LOAD = "a list of 'stored procedures' to execute prior to the 'script' (if 'script' is not specified then the last script in this argument will return the values";
    private static final String API_RETURN_TOTAL = "when set to true, the full result set will be iterated and the results returned (default is false)";

    @ExtensionDefinition(extensionPoint=ExtensionPoint.EDGE, method=HttpMethod.GET)
    @ExtensionDescriptor(description="evaluate an ad-hoc Gremlin script for an edge.", api={@ExtensionApi(parameterName="rexster.showTypes", description="displays the properties of the elements with their native data type (default is false)"), @ExtensionApi(parameterName="language", description="the gremlin language flavor to use (default is groovy)"), @ExtensionApi(parameterName="params", description="a map of parameters to bind to the script engine"), @ExtensionApi(parameterName="load", description="a list of 'stored procedures' to execute prior to the 'script' (if 'script' is not specified then the last script in this argument will return the values"), @ExtensionApi(parameterName="returnTotal", description="when set to true, the full result set will be iterated and the results returned (default is false)"), @ExtensionApi(parameterName="rexster.returnKeys", description="an array of element property keys to return (default is to return all element properties)"), @ExtensionApi(parameterName="rexster.offset.start", description="start index for a paged set of data to be returned"), @ExtensionApi(parameterName="rexster.offset.end", description="end index for a paged set of data to be returned")})
    public ExtensionResponse evaluateGetOnEdge(@RexsterContext RexsterResourceContext rexsterResourceContext, @RexsterContext Graph graph, @RexsterContext Edge edge, @ExtensionRequestParameter(name="script", description="the Gremlin script to be evaluated", parseToJson=false) String script) {
        return this.tryExecuteGremlinScript(rexsterResourceContext, graph, null, edge, script);
    }

    @ExtensionDefinition(extensionPoint=ExtensionPoint.EDGE, method=HttpMethod.POST)
    @ExtensionDescriptor(description="evaluate an ad-hoc Gremlin script for an edge.", api={@ExtensionApi(parameterName="rexster.showTypes", description="displays the properties of the elements with their native data type (default is false)"), @ExtensionApi(parameterName="language", description="the gremlin language flavor to use (default is groovy)"), @ExtensionApi(parameterName="params", description="a map of parameters to bind to the script engine"), @ExtensionApi(parameterName="load", description="a list of 'stored procedures' to execute prior to the 'script' (if 'script' is not specified then the last script in this argument will return the values"), @ExtensionApi(parameterName="returnTotal", description="when set to true, the full result set will be iterated and the results returned (default is false)"), @ExtensionApi(parameterName="rexster.returnKeys", description="an array of element property keys to return (default is to return all element properties)"), @ExtensionApi(parameterName="rexster.offset.start", description="start index for a paged set of data to be returned"), @ExtensionApi(parameterName="rexster.offset.end", description="end index for a paged set of data to be returned")})
    public ExtensionResponse evaluatePostOnEdge(@RexsterContext RexsterResourceContext rexsterResourceContext, @RexsterContext Graph graph, @RexsterContext Edge edge, @ExtensionRequestParameter(name="script", description="the Gremlin script to be evaluated", parseToJson=false) String script) {
        return this.tryExecuteGremlinScript(rexsterResourceContext, graph, null, edge, script);
    }

    @ExtensionDefinition(extensionPoint=ExtensionPoint.VERTEX, method=HttpMethod.GET)
    @ExtensionDescriptor(description="evaluate an ad-hoc Gremlin script for a vertex.", api={@ExtensionApi(parameterName="rexster.showTypes", description="displays the properties of the elements with their native data type (default is false)"), @ExtensionApi(parameterName="language", description="the gremlin language flavor to use (default is groovy)"), @ExtensionApi(parameterName="params", description="a map of parameters to bind to the script engine"), @ExtensionApi(parameterName="load", description="a list of 'stored procedures' to execute prior to the 'script' (if 'script' is not specified then the last script in this argument will return the values"), @ExtensionApi(parameterName="returnTotal", description="when set to true, the full result set will be iterated and the results returned (default is false)"), @ExtensionApi(parameterName="rexster.returnKeys", description="an array of element property keys to return (default is to return all element properties)"), @ExtensionApi(parameterName="rexster.offset.start", description="start index for a paged set of data to be returned"), @ExtensionApi(parameterName="rexster.offset.end", description="end index for a paged set of data to be returned")})
    public ExtensionResponse evaluateGetOnVertex(@RexsterContext RexsterResourceContext rexsterResourceContext, @RexsterContext Graph graph, @RexsterContext Vertex vertex, @ExtensionRequestParameter(name="script", description="the Gremlin script to be evaluated", parseToJson=false) String script) {
        return this.tryExecuteGremlinScript(rexsterResourceContext, graph, vertex, null, script);
    }

    @ExtensionDefinition(extensionPoint=ExtensionPoint.VERTEX, method=HttpMethod.POST)
    @ExtensionDescriptor(description="evaluate an ad-hoc Gremlin script for a vertex.", api={@ExtensionApi(parameterName="rexster.showTypes", description="displays the properties of the elements with their native data type (default is false)"), @ExtensionApi(parameterName="language", description="the gremlin language flavor to use (default is groovy)"), @ExtensionApi(parameterName="params", description="a map of parameters to bind to the script engine"), @ExtensionApi(parameterName="load", description="a list of 'stored procedures' to execute prior to the 'script' (if 'script' is not specified then the last script in this argument will return the values"), @ExtensionApi(parameterName="returnTotal", description="when set to true, the full result set will be iterated and the results returned (default is false)"), @ExtensionApi(parameterName="rexster.returnKeys", description="an array of element property keys to return (default is to return all element properties)"), @ExtensionApi(parameterName="rexster.offset.start", description="start index for a paged set of data to be returned"), @ExtensionApi(parameterName="rexster.offset.end", description="end index for a paged set of data to be returned")})
    public ExtensionResponse evaluatePostOnVertex(@RexsterContext RexsterResourceContext rexsterResourceContext, @RexsterContext Graph graph, @RexsterContext Vertex vertex, @ExtensionRequestParameter(name="script", description="the Gremlin script to be evaluated", parseToJson=false) String script) {
        return this.tryExecuteGremlinScript(rexsterResourceContext, graph, vertex, null, script);
    }

    @ExtensionDefinition(extensionPoint=ExtensionPoint.GRAPH, method=HttpMethod.GET)
    @ExtensionDescriptor(description="evaluate an ad-hoc Gremlin script for a graph.", api={@ExtensionApi(parameterName="rexster.showTypes", description="displays the properties of the elements with their native data type (default is false)"), @ExtensionApi(parameterName="language", description="the gremlin language flavor to use (default is groovy)"), @ExtensionApi(parameterName="params", description="a map of parameters to bind to the script engine"), @ExtensionApi(parameterName="load", description="a list of 'stored procedures' to execute prior to the 'script' (if 'script' is not specified then the last script in this argument will return the values"), @ExtensionApi(parameterName="returnTotal", description="when set to true, the full result set will be iterated and the results returned (default is false)"), @ExtensionApi(parameterName="rexster.returnKeys", description="an array of element property keys to return (default is to return all element properties)"), @ExtensionApi(parameterName="rexster.offset.start", description="start index for a paged set of data to be returned"), @ExtensionApi(parameterName="rexster.offset.end", description="end index for a paged set of data to be returned")})
    public ExtensionResponse evaluateGetOnGraph(@RexsterContext RexsterResourceContext rexsterResourceContext, @RexsterContext Graph graph, @ExtensionRequestParameter(name="script", description="the Gremlin script to be evaluated", parseToJson=false) String script) {
        return this.tryExecuteGremlinScript(rexsterResourceContext, graph, null, null, script);
    }

    @ExtensionDefinition(extensionPoint=ExtensionPoint.GRAPH, method=HttpMethod.POST)
    @ExtensionDescriptor(description="evaluate an ad-hoc Gremlin script for a graph.", api={@ExtensionApi(parameterName="rexster.showTypes", description="displays the properties of the elements with their native data type (default is false)"), @ExtensionApi(parameterName="language", description="the gremlin language flavor to use (default is groovy)"), @ExtensionApi(parameterName="params", description="a map of parameters to bind to the script engine"), @ExtensionApi(parameterName="load", description="a list of 'stored procedures' to execute prior to the 'script' (if 'script' is not specified then the last script in this argument will return the values"), @ExtensionApi(parameterName="returnTotal", description="when set to true, the full result set will be iterated and the results returned (default is false)"), @ExtensionApi(parameterName="rexster.returnKeys", description="an array of element property keys to return (default is to return all element properties)"), @ExtensionApi(parameterName="rexster.offset.start", description="start index for a paged set of data to be returned"), @ExtensionApi(parameterName="rexster.offset.end", description="end index for a paged set of data to be returned")})
    public ExtensionResponse evaluatePostOnGraph(@RexsterContext RexsterResourceContext rexsterResourceContext, @RexsterContext Graph graph, @ExtensionRequestParameter(name="script", description="the Gremlin script to be evaluated", parseToJson=false) String script) {
        return this.tryExecuteGremlinScript(rexsterResourceContext, graph, null, null, script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtensionResponse tryExecuteGremlinScript(RexsterResourceContext rexsterResourceContext, Graph graph, Vertex vertex, Edge edge, String script) {
        ExtensionResponse extensionResponse;
        ScriptEngine scriptEngine;
        EngineHolder engineHolder;
        MetricRegistry metricRegistry = rexsterResourceContext.getMetricRegistry();
        Timer scriptTimer = metricRegistry.timer(MetricRegistry.name((String)"http", (String[])new String[]{"script-engine"}));
        Counter successfulExecutions = metricRegistry.counter(MetricRegistry.name((String)"http", (String[])new String[]{"script-engine", "success"}));
        Counter failedExecutions = metricRegistry.counter(MetricRegistry.name((String)"http", (String[])new String[]{"script-engine", "fail"}));
        JSONObject requestObject = rexsterResourceContext.getRequestObject();
        EngineController engineController = EngineController.getInstance();
        boolean showTypes = RequestObjectHelper.getShowTypes((JSONObject)requestObject);
        long offsetStart = RequestObjectHelper.getStartOffset((JSONObject)requestObject);
        long offsetEnd = RequestObjectHelper.getEndOffset((JSONObject)requestObject);
        boolean returnTotal = GremlinExtension.getReturnTotal(requestObject);
        GraphSONMode mode = showTypes ? GraphSONMode.EXTENDED : GraphSONMode.NORMAL;
        Set returnKeys = RequestObjectHelper.getReturnKeys((JSONObject)requestObject, (String)WILDCARD);
        String languageToExecuteWith = GremlinExtension.getLanguageToExecuteWith(requestObject);
        try {
            if (!engineController.isEngineAvailable(languageToExecuteWith)) {
                return ExtensionResponse.error((String)"language requested is not available on the server");
            }
            engineHolder = engineController.getEngineByLanguageName(languageToExecuteWith);
            scriptEngine = engineHolder.getEngine();
        }
        catch (ScriptException se) {
            return ExtensionResponse.error((String)"could not get request script engine");
        }
        Bindings bindings = GremlinExtension.createBindings(graph, vertex, edge, scriptEngine);
        GremlinExtension.placeParametersOnBinding(requestObject, bindings, showTypes);
        RexsterApplicationGraph rag = rexsterResourceContext.getRexsterApplicationGraph();
        ExtensionMethod extensionMethod = rexsterResourceContext.getExtensionMethod();
        Map configurationMap = null;
        Iterator<String> scriptsToRun = null;
        try {
            ExtensionConfiguration extensionConfiguration;
            ExtensionConfiguration extensionConfiguration2 = extensionConfiguration = rag != null ? rag.findExtensionConfiguration(EXTENSION_NAMESPACE, EXTENSION_NAME) : null;
            if (extensionConfiguration != null) {
                configurationMap = extensionConfiguration.tryGetMapFromConfiguration();
                scriptsToRun = GremlinExtension.getScriptsToRun(requestObject, configurationMap);
            }
        }
        catch (IOException ioe) {
            return ExtensionResponse.error((Exception)ioe, (JSONObject)this.generateErrorJson(extensionMethod.getExtensionApiAsJson()));
        }
        if ((script == null || script.isEmpty()) && scriptsToRun == null) {
            return ExtensionResponse.badRequest((String)"no scripts provided", (JSONObject)this.generateErrorJson(extensionMethod.getExtensionApiAsJson()));
        }
        Timer.Context context = scriptTimer.time();
        try {
            Object result = null;
            if (scriptsToRun != null) {
                while (scriptsToRun.hasNext()) {
                    result = engineHolder.getEngine().eval(scriptsToRun.next(), bindings);
                }
            }
            if (GremlinExtension.isClientScriptAllowed(configurationMap) && script != null && !script.isEmpty()) {
                result = engineHolder.getEngine().eval(script, bindings);
            }
            Pair convertedResults = new JSONResultConverter(mode, offsetStart, offsetEnd, returnKeys).convert(result, returnTotal);
            JSONArray results = (JSONArray)convertedResults.getA();
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("success", true);
            resultMap.put("results", results);
            if (returnTotal) {
                resultMap.put("count", convertedResults.getB());
            }
            JSONObject resultObject = new JSONObject(resultMap);
            extensionResponse = ExtensionResponse.ok((JSONObject)resultObject);
            successfulExecutions.inc();
        }
        catch (Exception e) {
            logger.error((Object)String.format("Gremlin Extension: %s", e.getMessage()), (Throwable)e);
            extensionResponse = ExtensionResponse.error((Exception)e, (JSONObject)this.generateErrorJson(extensionMethod.getExtensionApiAsJson()));
            failedExecutions.inc();
        }
        finally {
            context.stop();
        }
        return extensionResponse;
    }

    private static Bindings createBindings(Graph graph, Vertex vertex, Edge edge, ScriptEngine scriptEngine) {
        Bindings bindings = scriptEngine.createBindings();
        bindings.put(GRAPH_VARIABLE, (Object)graph);
        if (vertex != null) {
            bindings.put(VERTEX_VARIABLE, (Object)vertex);
        }
        if (edge != null) {
            bindings.put(EDGE_VARIABLE, (Object)edge);
        }
        return bindings;
    }

    private static void placeParametersOnBinding(JSONObject requestObject, Bindings bindings, boolean parseTypes) {
        JSONObject paramMap;
        if (requestObject != null && (paramMap = requestObject.optJSONObject(PARAMS)) != null) {
            Iterator keyIterator = paramMap.keys();
            while (keyIterator.hasNext()) {
                String key = (String)keyIterator.next();
                bindings.put(key, ElementHelper.getTypedPropertyValue((Object)paramMap.opt(key), (boolean)parseTypes));
            }
        }
    }

    private static String getLanguageToExecuteWith(JSONObject requestObject) {
        String language = requestObject != null ? requestObject.optString(LANGUAGE) : null;
        String requestedLanguage = "groovy";
        if (language != null && !language.equals("")) {
            requestedLanguage = language;
        }
        return requestedLanguage;
    }

    private static boolean getReturnTotal(JSONObject requestObject) {
        String retTotalString = requestObject != null ? requestObject.optString(RETURN_TOTAL) : null;
        boolean returnTotal = false;
        if (retTotalString != null && !retTotalString.equals("")) {
            returnTotal = Boolean.parseBoolean(retTotalString);
        }
        return returnTotal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static Iterator<String> getScriptsToRun(JSONObject requestObject, Map configuration) throws IOException {
        if (configuration == null) {
            logger.warn((Object)"No scripts are configured for the Gremlin Extension so 'load' query string parameter will be ignored");
            return null;
        }
        if (!configuration.containsKey("scripts")) {
            logger.warn((Object)"The configuration suppled for the Gremlin Extension does not contain a 'scripts' key so 'load' query string parameter will be ignored");
            return null;
        }
        boolean scriptsAreCached = GremlinExtension.areScriptsCached(configuration);
        String scriptLocation = (String)configuration.get("scripts");
        JSONArray jsonArray = requestObject != null ? requestObject.optJSONArray(LOAD) : null;
        Iterator scripts = null;
        if (jsonArray == null) return scripts;
        ArrayList<String> scriptList = new ArrayList<String>();
        int ix = 0;
        while (ix < jsonArray.length()) {
            String locationAndScriptFile = scriptLocation + File.separator + jsonArray.optString(ix) + ".gremlin";
            String script = (String)cachedScripts.get(locationAndScriptFile);
            if (script == null) {
                script = GremlinExtension.readFile(locationAndScriptFile);
                if (scriptsAreCached) {
                    Class<GremlinExtension> clazz = GremlinExtension.class;
                    // MONITORENTER : com.tinkerpop.rexster.gremlin.GremlinExtension.class
                    cachedScripts.putIfAbsent(locationAndScriptFile, script);
                    // MONITOREXIT : clazz
                }
            }
            scriptList.add(script);
            ++ix;
        }
        return scriptList.iterator();
    }

    private static synchronized String readFile(String fileName) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtils.copy((InputStream)new FileInputStream(new File(fileName)), (Writer)stringWriter);
        return stringWriter.toString();
    }

    private static boolean isClientScriptAllowed(Map configuration) {
        boolean allowClientScript = true;
        if (configuration != null && configuration.containsKey("allow-client-script")) {
            String configValue = (String)configuration.get("allow-client-script");
            allowClientScript = configValue.toLowerCase().equals("true");
        }
        return allowClientScript;
    }

    private static boolean areScriptsCached(Map configuration) {
        boolean cacheScripts = true;
        if (configuration != null && configuration.containsKey("cache-scripts")) {
            String configValue = (String)configuration.get("cache-scripts");
            cacheScripts = configValue.toLowerCase().equals("true");
        }
        return cacheScripts;
    }
}

