/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.gremlin;

import com.tinkerpop.rexster.gremlin.GremlinSession;
import com.tinkerpop.rexster.server.RexsterApplication;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class GremlinSessions {
    protected static ConcurrentHashMap<String, GremlinSession> sessions = new ConcurrentHashMap();

    public static GremlinSession getSession(String sessionId, String graphName, RexsterApplication ra) {
        GremlinSessions.ensureSessionExists(sessionId, graphName, ra);
        return sessions.get(sessionId + graphName);
    }

    public static GremlinSession findSessionByKey(String sessionKey) {
        return sessions.get(sessionKey);
    }

    public static void destroySession(String sessionId, String graphName) {
        GremlinSessions.destroySession(sessionId + graphName);
    }

    public static void destroySession(String sessionKey) {
        sessions.get(sessionKey).die();
        sessions.remove(sessionKey);
    }

    public static void destroyAllSessions() {
        Iterator keys = sessions.keySet().iterator();
        while (keys.hasNext()) {
            GremlinSessions.destroySession((String)keys.next());
        }
    }

    public static boolean hasSession(String sessionId, String graphName) {
        return GremlinSessions.hasSessionKey(sessionId + graphName);
    }

    public static boolean hasSessionKey(String sessionKey) {
        return sessions.containsKey(sessionKey);
    }

    public static Collection<String> getSessionKeys() {
        return sessions.keySet();
    }

    protected static void ensureSessionExists(String sessionId, String graphName, RexsterApplication ra) {
        String key = sessionId + graphName;
        if (!sessions.containsKey(key)) {
            sessions.put(key, new GremlinSession(graphName, ra));
        }
    }
}

