/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.server.metrics;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.tinkerpop.rexster.server.metrics.AbstractReporterConfig;
import com.tinkerpop.rexster.server.metrics.RegexMetricFilter;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;

class ConsoleReporterConfig
extends AbstractReporterConfig {
    private static final Logger logger = Logger.getLogger(ConsoleReporterConfig.class);
    private ConsoleReporter consoleReporter;

    public ConsoleReporterConfig(HierarchicalConfiguration config, MetricRegistry metricRegistry) {
        super(config, metricRegistry);
        logger.info((Object)"Configured Console Metric Reporter.");
    }

    @Override
    public boolean enable() {
        try {
            this.consoleReporter = ConsoleReporter.forRegistry((MetricRegistry)this.metricRegistry).convertDurationsTo(this.getRealDurationTimeUnitConversion()).convertRatesTo(this.getRealRateTimeUnitConversion()).filter((MetricFilter)new RegexMetricFilter(this.inclusion, this.exclusion)).build();
            this.consoleReporter.start(this.period, this.getRealTimeUnit());
        }
        catch (Exception e) {
            logger.error((Object)"Failure while enabling console reporter", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public void disable() {
        this.consoleReporter.stop();
    }
}

