/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import org.jboss.modules.AliasModuleSpec;
import org.jboss.modules.ConcreteModuleSpec;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.FastCopyHashSet;
import org.jboss.modules.LocalModuleFinder;
import org.jboss.modules.ModuleDependencySpec;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;

public final class DependencyTreeViewer {
    private static <I, O extends I> O[] filtered(Class<O[]> oType, I ... inputs) {
        I[] newArray = Arrays.copyOf(inputs, inputs.length);
        int o = 0;
        for (int i = 0; i < inputs.length; ++i) {
            if (!oType.getComponentType().isInstance(inputs[i])) continue;
            newArray[o++] = inputs[i];
        }
        return Arrays.copyOf(newArray, o, oType);
    }

    private static void print(PrintWriter out, String prefix, ModuleSpec spec, FastCopyHashSet<ModuleIdentifier> visited, File ... roots) {
        if (spec instanceof AliasModuleSpec) {
            AliasModuleSpec aliasModuleSpec = (AliasModuleSpec)spec;
            out.print(" -> ");
            ModuleIdentifier aliasTarget = aliasModuleSpec.getAliasTarget();
            out.print(aliasTarget);
            if (visited.add(aliasTarget)) {
                try {
                    ModuleSpec moduleSpec = LocalModuleFinder.parseModuleXmlFile(aliasTarget, null, roots);
                    DependencyTreeViewer.print(out, prefix, moduleSpec, visited, new File[0]);
                }
                catch (IOException e) {
                    out.println(e);
                }
                catch (ModuleLoadException e) {
                    out.println(e);
                }
            }
        } else if (spec instanceof ConcreteModuleSpec) {
            out.println();
            ConcreteModuleSpec concreteModuleSpec = (ConcreteModuleSpec)spec;
            DependencySpec[] dependencies = (DependencySpec[])DependencyTreeViewer.filtered(ModuleDependencySpec[].class, concreteModuleSpec.getDependencies());
            int dependenciesLength = dependencies.length;
            for (int i = 0; i < dependenciesLength; ++i) {
                DependencyTreeViewer.print(out, prefix, dependencies[i], visited, i == dependenciesLength - 1, roots);
            }
        } else {
            out.println();
        }
    }

    private static void print(PrintWriter out, String prefix, DependencySpec spec, FastCopyHashSet<ModuleIdentifier> visited, boolean last, File ... roots) {
        if (spec instanceof ModuleDependencySpec) {
            PathFilter exportFilter;
            ModuleDependencySpec moduleDependencySpec = (ModuleDependencySpec)spec;
            ModuleIdentifier identifier = moduleDependencySpec.getIdentifier();
            out.print(prefix);
            out.print(last ? (char)'\u2514' : '\u251c');
            out.print('\u2500');
            out.print(' ');
            out.print(identifier);
            if (moduleDependencySpec.isOptional()) {
                out.print(" (optional)");
            }
            if (!(exportFilter = moduleDependencySpec.getExportFilter()).equals(PathFilters.rejectAll())) {
                out.print(" (exported)");
            }
            if (visited.add(identifier)) {
                DependencyTreeViewer.print(out, prefix + (last ? "   " : "\u2502  "), identifier, visited, roots);
            } else {
                out.println();
            }
        }
    }

    private static void print(PrintWriter out, String prefix, ModuleIdentifier identifier, FastCopyHashSet<ModuleIdentifier> visited, File ... roots) {
        try {
            ModuleSpec moduleSpec = LocalModuleFinder.parseModuleXmlFile(identifier, null, roots);
            if (moduleSpec == null) {
                out.println(" (not found)");
            } else {
                DependencyTreeViewer.print(out, prefix, moduleSpec, visited, roots);
            }
        }
        catch (IOException e) {
            out.print(" (");
            out.print(e);
            out.println(")");
        }
        catch (ModuleLoadException e) {
            out.print(" (");
            out.print(e);
            out.println(")");
        }
    }

    public static void print(PrintWriter out, ModuleIdentifier identifier, File ... roots) {
        out.print(identifier);
        DependencyTreeViewer.print(out, "", identifier, new FastCopyHashSet<ModuleIdentifier>(), roots);
        out.flush();
    }
}

