/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.files;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.wrappers.event.listener.GraphChangedListener;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.files.FileMapping;

public class FileMappingGraphChangedListener
implements GraphChangedListener {
    private static final Logger LOG = Logger.getLogger(FileMappingGraphChangedListener.class.getSimpleName());
    private GraphRewrite event;

    public FileMappingGraphChangedListener(GraphRewrite event) {
        this.event = event;
    }

    public void vertexPropertyChanged(Vertex vertex, String key, Object oldValue, Object setValue) {
        if ("filePath".equals(key)) {
            FileService fileService = new FileService(this.event.getGraphContext());
            FileModel model = (FileModel)fileService.frame(vertex);
            Map mappings = FileMapping.getMappings((GraphRewrite)this.event);
            for (Map.Entry entry : mappings.entrySet()) {
                String pattern = (String)entry.getKey();
                List types = (List)entry.getValue();
                if (!((String)setValue).matches(pattern) || model.isDirectory()) continue;
                for (Class type : types) {
                    GraphService.addTypeToModel((GraphContext)this.event.getGraphContext(), (WindupVertexFrame)model, (Class)type);
                }
                LOG.info("Mapped file [" + model.getFilePath() + "] matching pattern [" + pattern + "] to the following [" + types.size() + "] types: " + types);
            }
        }
    }

    public void vertexPropertyRemoved(Vertex vertex, String key, Object removedValue) {
    }

    public void vertexAdded(Vertex vertex) {
    }

    public void vertexRemoved(Vertex vertex, Map<String, Object> props) {
    }

    public void edgeAdded(Edge edge) {
    }

    public void edgePropertyChanged(Edge edge, String key, Object oldValue, Object setValue) {
    }

    public void edgePropertyRemoved(Edge edge, String key, Object removedValue) {
    }

    public void edgeRemoved(Edge edge, Map<String, Object> props) {
    }
}

