/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.enterprise.inject.Vetoed;
import org.jboss.aesh.console.AeshConsole;
import org.jboss.aesh.console.AeshConsoleBuilder;
import org.jboss.aesh.console.AeshConsoleImpl;
import org.jboss.aesh.console.Console;
import org.jboss.aesh.console.Prompt;
import org.jboss.aesh.console.command.CommandNotFoundException;
import org.jboss.aesh.console.command.container.CommandContainer;
import org.jboss.aesh.console.command.invocation.AeshCommandInvocation;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.console.command.registry.CommandRegistry;
import org.jboss.aesh.console.export.ExportManager;
import org.jboss.aesh.console.helper.InterruptHook;
import org.jboss.aesh.console.operator.ControlOperator;
import org.jboss.aesh.console.settings.CommandNotFoundHandler;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.console.settings.SettingsBuilder;
import org.jboss.aesh.edit.actions.Action;
import org.jboss.aesh.io.FileResource;
import org.jboss.aesh.io.Resource;
import org.jboss.aesh.terminal.CharacterType;
import org.jboss.aesh.terminal.Color;
import org.jboss.aesh.terminal.POSIXTerminal;
import org.jboss.aesh.terminal.Terminal;
import org.jboss.aesh.terminal.TerminalCharacter;
import org.jboss.aesh.terminal.TerminalColor;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.shell.CommandNotFoundListener;
import org.jboss.forge.addon.shell.Shell;
import org.jboss.forge.addon.shell.aesh.ForgeCommandNotFoundHandler;
import org.jboss.forge.addon.shell.aesh.ForgeCommandRegistry;
import org.jboss.forge.addon.shell.ui.DidYouMeanCommandNotFoundListener;
import org.jboss.forge.addon.shell.ui.ShellContext;
import org.jboss.forge.addon.shell.ui.ShellContextImpl;
import org.jboss.forge.addon.shell.ui.ShellUIOutputImpl;
import org.jboss.forge.addon.shell.ui.ShellUIProgressMonitor;
import org.jboss.forge.addon.shell.ui.ShellUIPromptImpl;
import org.jboss.forge.addon.ui.DefaultUIDesktop;
import org.jboss.forge.addon.ui.UIDesktop;
import org.jboss.forge.addon.ui.UIRuntime;
import org.jboss.forge.addon.ui.command.CommandExecutionListener;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextListener;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.progress.UIProgressMonitor;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.spi.ListenerRegistration;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.OperatingSystemUtils;

@Vetoed
public class ShellImpl
implements Shell,
UIRuntime {
    private org.jboss.forge.addon.resource.Resource<?> currentResource;
    private final AddonRegistry addonRegistry;
    private final AeshConsole console;
    private final UIOutput output;
    private UIDesktop desktop;
    private final List<CommandExecutionListener> executionListeners = new LinkedList<CommandExecutionListener>();
    private final List<CommandNotFoundListener> commandNotFoundListeners = new LinkedList<CommandNotFoundListener>();
    private static final Logger log = Logger.getLogger(ShellImpl.class.getName());

    public ShellImpl(Furnace furnace, org.jboss.forge.addon.resource.Resource<?> initialResource, Settings settings, AddonRegistry addonRegistry) {
        this.addonRegistry = addonRegistry;
        File forgeHome = OperatingSystemUtils.getUserForgeDir();
        File history = new File(forgeHome, "history");
        File alias = new File(forgeHome, "alias");
        File export = new File(forgeHome, "export");
        ForgeCommandRegistry registry = new ForgeCommandRegistry(furnace, this, addonRegistry);
        this.commandNotFoundListeners.add(new DidYouMeanCommandNotFoundListener(registry));
        SettingsBuilder newSettings = new SettingsBuilder(settings).historyFile(history).aliasFile(alias).exportFile(export).enableExport(true).setExportUsesSystemEnvironment(true).interruptHook((InterruptHook)new ForgeInterruptHook(registry));
        if (Boolean.getBoolean("org.jboss.forge.addon.shell.forcePOSIXTerminal")) {
            newSettings.terminal((Terminal)new POSIXTerminal());
        }
        this.console = new AeshConsoleBuilder().prompt(ShellImpl.createPrompt(initialResource)).settings(newSettings.create()).commandRegistry((CommandRegistry)registry).commandNotFoundHandler((CommandNotFoundHandler)new ForgeCommandNotFoundHandler(this, this.commandNotFoundListeners)).create();
        this.output = new ShellUIOutputImpl(this.console);
        this.setCurrentResource(initialResource);
        this.console.start();
    }

    private void updatePrompt() {
        this.console.setPrompt(ShellImpl.createPrompt(this.getCurrentResource()));
    }

    private static Prompt createPrompt(org.jboss.forge.addon.resource.Resource<?> currentResource) {
        if (OperatingSystemUtils.isWindows()) {
            LinkedList<TerminalCharacter> prompt = new LinkedList<TerminalCharacter>();
            prompt.add(new TerminalCharacter('['));
            for (char c : currentResource.getName().toCharArray()) {
                prompt.add(new TerminalCharacter(c));
            }
            prompt.add(new TerminalCharacter(']'));
            prompt.add(new TerminalCharacter('$'));
            prompt.add(new TerminalCharacter(' '));
            return new Prompt(prompt);
        }
        LinkedList<TerminalCharacter> prompt = new LinkedList<TerminalCharacter>();
        prompt.add(new TerminalCharacter('[', new TerminalColor(Color.BLUE, Color.DEFAULT), CharacterType.BOLD));
        for (char c : currentResource.getName().toCharArray()) {
            prompt.add(new TerminalCharacter(c));
        }
        prompt.add(new TerminalCharacter(']', new TerminalColor(Color.BLUE, Color.DEFAULT), CharacterType.BOLD));
        prompt.add(new TerminalCharacter('$'));
        prompt.add(new TerminalCharacter(' '));
        return new Prompt(prompt);
    }

    @PreDestroy
    public void close() {
        this.executionListeners.clear();
        this.commandNotFoundListeners.clear();
        this.console.stop();
    }

    public org.jboss.forge.addon.resource.Resource<?> getCurrentResource() {
        return this.currentResource;
    }

    public void setCurrentResource(org.jboss.forge.addon.resource.Resource<?> resource) {
        File dir;
        org.jboss.forge.addon.resource.Resource temp;
        Assert.notNull(resource, (String)"Current resource should not be null");
        this.currentResource = resource;
        for (temp = resource; !(temp instanceof DirectoryResource) && temp != null; temp = temp.getParent()) {
        }
        if (temp instanceof DirectoryResource && (dir = (File)((DirectoryResource)temp).getUnderlyingResourceObject()).exists()) {
            this.console.getAeshContext().setCurrentWorkingDirectory((Resource)new FileResource(dir));
        }
        this.updatePrompt();
    }

    public boolean isGUI() {
        return false;
    }

    public AeshConsole getConsole() {
        return this.console;
    }

    public UIOutput getOutput() {
        return this.output;
    }

    public ShellContextImpl createUIContext() {
        Imported listeners = this.addonRegistry.getServices(UIContextListener.class);
        ShellContextImpl shellContextImpl = new ShellContextImpl(this, this.currentResource, (Iterable<UIContextListener>)listeners);
        for (CommandExecutionListener listener : this.executionListeners) {
            shellContextImpl.addCommandExecutionListener(listener);
        }
        ExportManager exportManager = this.console.getExportManager();
        if (exportManager != null) {
            Map attributeMap = shellContextImpl.getAttributeMap();
            for (String variableName : exportManager.getAllNames()) {
                String variableValue = exportManager.getValue(variableName);
                attributeMap.put(variableName, variableValue);
            }
        }
        return shellContextImpl;
    }

    public ListenerRegistration<CommandExecutionListener> addCommandExecutionListener(final CommandExecutionListener listener) {
        this.executionListeners.add(listener);
        return new ListenerRegistration<CommandExecutionListener>(){

            public CommandExecutionListener removeListener() {
                ShellImpl.this.executionListeners.remove(listener);
                return listener;
            }
        };
    }

    public ListenerRegistration<CommandNotFoundListener> addCommandNotFoundListener(final CommandNotFoundListener listener) {
        this.commandNotFoundListeners.add(listener);
        return new ListenerRegistration<CommandNotFoundListener>(){

            public CommandNotFoundListener removeListener() {
                ShellImpl.this.commandNotFoundListeners.remove(listener);
                return listener;
            }
        };
    }

    public UIProgressMonitor createProgressMonitor(UIContext context) {
        return new ShellUIProgressMonitor(this.console.getShell().out());
    }

    public ShellUIPromptImpl createPrompt(UIContext context) {
        ShellContext shellContext = (ShellContext)context;
        ConverterFactory converterFactory = (ConverterFactory)this.addonRegistry.getServices(ConverterFactory.class).get();
        return new ShellUIPromptImpl(shellContext, converterFactory);
    }

    public void setDesktop(UIDesktop desktop) {
        this.desktop = desktop;
    }

    public UIDesktop getDesktop() {
        if (this.desktop == null) {
            this.desktop = new DefaultUIDesktop();
        }
        return this.desktop;
    }

    private class ForgeInterruptHook
    implements InterruptHook {
        private final ForgeCommandRegistry registry;

        ForgeInterruptHook(ForgeCommandRegistry registry) {
            this.registry = registry;
        }

        public void handleInterrupt(Console console, Action action) {
            if (action == Action.INTERRUPT) {
                console.getShell().out().println("^C");
                console.clearBufferAndDisplayPrompt();
            } else if (action == Action.IGNOREEOF) {
                console.getShell().out().println("Use \"exit\" to leave the shell.");
                console.clearBufferAndDisplayPrompt();
            } else {
                try {
                    CommandContainer exitCommand = this.registry.getCommand("exit", "");
                    console.getShell().out().println();
                    exitCommand.getCommand().execute((CommandInvocation)new AeshCommandInvocation((AeshConsoleImpl)ShellImpl.this.console, ControlOperator.NONE, 1, null));
                }
                catch (IOException | InterruptedException | CommandNotFoundException e) {
                    log.log(Level.WARNING, "Error while trying to run exit", e);
                }
            }
        }
    }
}

