/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.echo;

import java.io.IOException;
import java.util.List;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.terminal.Shell;

@CommandDefinition(name="echo", description="Echo the STRING(s) to standard output.")
public class Echo
implements Command<CommandInvocation> {
    @Option(shortName=104, name="help", hasValue=false, description="display this help and exit")
    private boolean help;
    @Arguments
    private List<String> arguments;

    public CommandResult execute(CommandInvocation commandInvocation) throws IOException {
        Shell shell = commandInvocation.getShell();
        if (this.help || this.arguments == null || this.arguments.isEmpty()) {
            shell.out().println(commandInvocation.getHelpInfo("echo"));
            return CommandResult.SUCCESS;
        }
        String stdout = "";
        for (String s : this.arguments) {
            stdout = stdout + s + " ";
        }
        stdout = stdout.trim();
        shell.out().println(stdout);
        return CommandResult.SUCCESS;
    }
}

