/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.text.highlight.scanner;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.jboss.aesh.extensions.text.highlight.Encoder;
import org.jboss.aesh.extensions.text.highlight.Scanner;
import org.jboss.aesh.extensions.text.highlight.StringScanner;
import org.jboss.aesh.extensions.text.highlight.TokenType;
import org.jboss.aesh.extensions.text.highlight.WordList;

public class SQLScanner
implements Scanner {
    private static final String[] KEYWORDS = new String[]{"all", "and", "any", "as", "before", "begin", "between", "by", "case", "check", "collate", "each", "else", "end", "exists", "for", "foreign", "from", "full", "group", "having", "if", "in", "inner", "is", "join", "like", "not", "of", "on", "or", "order", "outer", "over", "references", "then", "to", "union", "using", "values", "when", "where", "left", "right", "distinct"};
    private static final String[] OBJECTS = new String[]{"database", "databases", "table", "tables", "column", "columns", "fields", "index", "constraint", "constraints", "transaction", "function", "procedure", "row", "key", "view", "trigger"};
    private static final String[] COMMANDS = new String[]{"add", "alter", "comment", "create", "delete", "drop", "grant", "insert", "into", "select", "update", "set", "show", "prompt", "begin", "commit", "rollback", "replace", "truncate"};
    private static final String[] PREDEFINED_TYPES = new String[]{"char", "varchar", "varchar2", "enum", "binary", "text", "tinytext", "mediumtext", "longtext", "blob", "tinyblob", "mediumblob", "longblob", "timestamp", "date", "time", "datetime", "year", "double", "decimal", "float", "int", "integer", "tinyint", "mediumint", "bigint", "smallint", "unsigned", "bit", "bool", "boolean", "hex", "bin", "oct"};
    private static final String[] PREDEFINED_FUNCTIONS = new String[]{"sum", "cast", "substring", "abs", "pi", "count", "min", "max", "avg", "now"};
    private static final String[] DIRECTIVES = new String[]{"auto_increment", "unique", "default", "charset", "initially", "deferred", "deferrable", "cascade", "immediate", "read", "write", "asc", "desc", "after", "primary", "foreign", "return", "engine"};
    private static final String[] PREDEFINED_CONSTANTS = new String[]{"null", "true", "false"};
    private static final WordList<TokenType> IDENT_KIND = new WordList<TokenType>(TokenType.ident, true).add(KEYWORDS, TokenType.keyword).add(OBJECTS, TokenType.type).add(COMMANDS, TokenType.class_).add(PREDEFINED_TYPES, TokenType.predefined_type).add(PREDEFINED_CONSTANTS, TokenType.predefined_constant).add(PREDEFINED_FUNCTIONS, TokenType.predefined).add(DIRECTIVES, TokenType.directive);
    private static Pattern ESCAPE = Pattern.compile(" [rbfntv\\n\\\\\\/'\"] | x[a-fA-F0-9]{1,2} | [0-7]{1,3} | . ", 36);
    private static Pattern UNICODE_ESCAPE = Pattern.compile(" u[a-fA-F0-9]{4} | U[a-fA-F0-9]{8} ", 4);
    private static Pattern STRING_PREFIXES = Pattern.compile("[xnb]|_\\w+", 2);
    private static Pattern SPACE = Pattern.compile(" \\s+ | \\\\\\n ", 4);
    private static Pattern COMMENT = Pattern.compile("(?:--\\s?|\\#).*", 4);
    private static Pattern COMMENT_DIRECTIVE = Pattern.compile(" /\\* (!)? (?: .*? \\*/ | .* ) ", 36);
    private static Pattern OPERATOR = Pattern.compile(" [*\\/=<>:;,!&^|()\\[\\]{}~%] | [-+\\.](?!\\d) ", 4);
    private static Pattern LETTER = Pattern.compile("[A-Za-z_]");
    private static Pattern STRING = Pattern.compile("(" + STRING_PREFIXES.pattern() + ")?([`\"'])", 2);
    private static Pattern IDENT = Pattern.compile(" @? [A-Za-z_][A-Za-z_0-9]* ", 4);
    private static Pattern HEX = Pattern.compile("0[xX][0-9A-Fa-f]+");
    private static Pattern OCTAL = Pattern.compile("0[0-7]+(?![89.eEfF])");
    private static Pattern INTEGER = Pattern.compile("[-+]?(?>\\d+)(?![.eEfF])");
    private static Pattern FLOAT = Pattern.compile("[-+]?(?:\\d[fF]|\\d*\\.\\d+(?:[eE][+-]?\\d+)?|\\d+[eE][+-]?\\d+)");
    private static Pattern PREDEFINED_CONSTANT = Pattern.compile("\\\\N");
    private static Pattern DELIMITER = Pattern.compile("[\"'`]");
    private static Pattern CHAR = Pattern.compile(" \\\\ (?: " + ESCAPE.pattern() + " | " + UNICODE_ESCAPE.pattern() + " ) ", 36);
    private static Pattern CONTENT = Pattern.compile(" \\\\ . ", 36);
    private static Pattern STRING_END = Pattern.compile(" \\\\ . ", 4);
    private static Map<String, Pattern> STRING_CONTENT_PATTERN = new HashMap<String, Pattern>();
    public static final Scanner.Type TYPE = new Scanner.Type("SQL", "\\.(sql|ddl|dml|dcl)$");

    public SQLScanner() {
        STRING_CONTENT_PATTERN.put("\"", Pattern.compile(" (?: [^\\\\\"] | \"\" )+ ", 4));
        STRING_CONTENT_PATTERN.put("'", Pattern.compile(" (?: [^\\\\'] | '' )+ ", 4));
        STRING_CONTENT_PATTERN.put("`", Pattern.compile(" (?: [^\\\\`] | `` )+ ", 4));
    }

    @Override
    public Scanner.Type getType() {
        return TYPE;
    }

    @Override
    public void scan(StringScanner source, Encoder encoder, Map<String, Object> options) {
        State state = State.initial;
        String stringType = null;
        boolean nameExpected = false;
        block4: while (source.hasMore()) {
            MatchResult m = null;
            switch (state) {
                case initial: {
                    m = source.scan(SPACE);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.space);
                        continue block4;
                    }
                    m = source.scan(COMMENT);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.comment);
                        continue block4;
                    }
                    m = source.scan(COMMENT_DIRECTIVE);
                    if (m != null) {
                        encoder.textToken(m.group(), m.group(1) != null ? TokenType.directive : TokenType.comment);
                        continue block4;
                    }
                    m = source.scan(OPERATOR);
                    if (m != null) {
                        if (m.group().equals(".") && source.check(LETTER) != null) {
                            nameExpected = true;
                        }
                        encoder.textToken(m.group(), TokenType.operator);
                        continue block4;
                    }
                    m = source.scan(STRING);
                    if (m != null) {
                        String prefix = m.group(1);
                        stringType = m.group(2);
                        encoder.beginGroup(TokenType.string);
                        if (prefix != null) {
                            encoder.textToken(prefix, TokenType.modifier);
                        }
                        state = State.string;
                        encoder.textToken(stringType, TokenType.delimiter);
                        continue block4;
                    }
                    m = source.scan(IDENT);
                    if (m != null) {
                        encoder.textToken(m.group(), nameExpected ? TokenType.ident : (m.group().startsWith("@") ? TokenType.variable : IDENT_KIND.lookup(m.group())));
                        nameExpected = false;
                        continue block4;
                    }
                    m = source.scan(HEX);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.hex);
                        continue block4;
                    }
                    m = source.scan(OCTAL);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.octal);
                        continue block4;
                    }
                    m = source.scan(INTEGER);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.integer);
                        continue block4;
                    }
                    m = source.scan(FLOAT);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.float_);
                        continue block4;
                    }
                    m = source.scan(PREDEFINED_CONSTANT);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.predefined_constant);
                        continue block4;
                    }
                    encoder.textToken(source.next(), TokenType.error);
                    continue block4;
                }
                case string: {
                    m = source.scan(STRING_CONTENT_PATTERN.get(stringType));
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.content);
                        continue block4;
                    }
                    m = source.scan(DELIMITER);
                    if (m != null) {
                        if (m.group().equals(stringType)) {
                            if (source.peek(1).equals(stringType)) {
                                encoder.textToken(m.group() + source.next(), TokenType.content);
                                continue block4;
                            }
                            encoder.textToken(m.group(), TokenType.delimiter);
                            encoder.endGroup(TokenType.string);
                            state = State.initial;
                            stringType = null;
                            continue block4;
                        }
                        encoder.textToken(m.group(), TokenType.content);
                        continue block4;
                    }
                    m = source.scan(CHAR);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.char_);
                        continue block4;
                    }
                    m = source.scan(CONTENT);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.content);
                        continue block4;
                    }
                    m = source.scan(STRING_END);
                    if (m != null) {
                        if (m.group().length() != 0) {
                            encoder.textToken(m.group(), TokenType.error);
                        }
                        encoder.endGroup(TokenType.string);
                        state = State.initial;
                        continue block4;
                    }
                    throw new RuntimeException("Else case reached; unhandled " + source.peek(1));
                }
            }
            throw new RuntimeException("Unknown state " + (Object)((Object)state));
        }
        if (state == State.string) {
            encoder.endGroup(TokenType.string);
        }
    }

    public static enum State {
        initial,
        string;

    }
}

