/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster;

import com.codahale.metrics.annotation.Timed;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.VertexQuery;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONMode;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONUtility;
import com.tinkerpop.rexster.AbstractSubResource;
import com.tinkerpop.rexster.RexsterApplicationGraph;
import com.tinkerpop.rexster.RexsterMediaType;
import com.tinkerpop.rexster.extension.ExtensionMethod;
import com.tinkerpop.rexster.extension.ExtensionPoint;
import com.tinkerpop.rexster.extension.ExtensionResponse;
import com.tinkerpop.rexster.extension.ExtensionSegmentSet;
import com.tinkerpop.rexster.extension.HttpMethod;
import com.tinkerpop.rexster.extension.RexsterExtension;
import com.tinkerpop.rexster.server.RexsterApplication;
import com.tinkerpop.rexster.util.ElementHelper;
import com.tinkerpop.rexster.util.RequestObjectHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

@Path(value="/graphs/{graphname}/vertices")
public class VertexResource
extends AbstractSubResource {
    private static Logger logger = Logger.getLogger(VertexResource.class);

    public VertexResource() {
        super(null);
    }

    public VertexResource(UriInfo ui, HttpServletRequest req, RexsterApplication ra) {
        super(ra);
        this.httpServletRequest = req;
        this.uriInfo = ui;
    }

    @OPTIONS
    public Response optionsVertices() {
        return this.buildOptionsResponse(HttpMethod.GET.toString(), HttpMethod.POST.toString());
    }

    @GET
    @Produces(value={"application/json", "application/vnd.rexster-v1+json"})
    @Timed(name="http.rest.vertices.collection.get", absolute=true)
    public Response getVertices(@PathParam(value="graphname") String graphName) {
        return this.getVertices(graphName, false);
    }

    @GET
    @Produces(value={"application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.vertices.collection.get", absolute=true)
    public Response getVerticesRexsterJson(@PathParam(value="graphname") String graphName) {
        return this.getVertices(graphName, true);
    }

    private Response getVertices(String graphName, boolean showTypes) {
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        Graph graph = rag.getGraph();
        GraphSONMode mode = showTypes ? GraphSONMode.EXTENDED : GraphSONMode.NORMAL;
        JSONObject theRequestObject = this.getRequestObject();
        Long start = RequestObjectHelper.getStartOffset((JSONObject)theRequestObject);
        Long end = RequestObjectHelper.getEndOffset((JSONObject)theRequestObject);
        Set returnKeys = RequestObjectHelper.getReturnKeys((JSONObject)theRequestObject);
        String key = null;
        Object value = null;
        Object temp = theRequestObject.opt("key");
        if (null != temp) {
            key = temp.toString();
        }
        if (null != (temp = theRequestObject.opt("value"))) {
            value = ElementHelper.getTypedPropertyValue((Object)temp.toString());
        }
        boolean filtered = key != null && value != null;
        try {
            long counter = 0L;
            JSONArray vertexArray = new JSONArray();
            boolean wasInSection = false;
            Iterable vertices = filtered ? graph.getVertices(key, value) : graph.getVertices();
            for (Vertex vertex : vertices) {
                if (counter >= start && counter < end) {
                    wasInSection = true;
                    vertexArray.put((Object)GraphSONUtility.jsonFromElement((Element)vertex, (Set)returnKeys, (GraphSONMode)mode));
                } else if (wasInSection) break;
                ++counter;
            }
            this.resultObject.put("results", (Object)vertexArray);
            this.resultObject.put("totalSize", vertexArray.length());
            this.resultObject.put("queryTime", this.sh.stopWatch());
        }
        catch (JSONException ex) {
            logger.error((Object)ex);
            JSONObject error = this.generateErrorObjectJsonFail(ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        catch (Exception re) {
            logger.error((Object)re);
            JSONObject error = this.generateErrorObject(re.getMessage(), re);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        finally {
            rag.tryCommit();
        }
        return Response.ok((Object)this.resultObject).build();
    }

    @OPTIONS
    @Path(value="/{id}")
    public Response optionsSingleVertex() {
        return this.buildOptionsResponse();
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @Timed(name="http.rest.vertices.object.get", absolute=true)
    public Response getSingleVertex(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id) {
        return this.getSingleVertex(graphName, id, false, false);
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/vnd.rexster-v1+json"})
    @Timed(name="http.rest.vertices.object.get", absolute=true)
    public Response getSingleVertexRexsterJson(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id) {
        return this.getSingleVertex(graphName, id, false, true);
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.vertices.object.get", absolute=true)
    public Response getSingleVertexRexsterTypedJson(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id) {
        return this.getSingleVertex(graphName, id, true, true);
    }

    private Response getSingleVertex(String graphName, String id, boolean showTypes, boolean showHypermedia) {
        block7: {
            RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
            try {
                Vertex vertex = rag.getGraph().getVertex((Object)id);
                if (null != vertex) {
                    JSONArray extensionsList;
                    JSONObject theRequestObject = this.getRequestObject();
                    GraphSONMode mode = showTypes ? GraphSONMode.EXTENDED : GraphSONMode.NORMAL;
                    Set returnKeys = RequestObjectHelper.getReturnKeys((JSONObject)theRequestObject);
                    this.resultObject.put("results", (Object)GraphSONUtility.jsonFromElement((Element)vertex, (Set)returnKeys, (GraphSONMode)mode));
                    this.resultObject.put("queryTime", this.sh.stopWatch());
                    if (showHypermedia && (extensionsList = rag.getExtensionHypermedia(ExtensionPoint.VERTEX, this.getUriPath())) != null) {
                        this.resultObject.put("extensions", (Object)extensionsList);
                    }
                    break block7;
                }
                String msg = "Vertex with [" + id + "] cannot be found.";
                logger.info((Object)msg);
                JSONObject error = this.generateErrorObject(msg);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build());
            }
            catch (JSONException ex) {
                logger.error((Object)ex);
                JSONObject error = this.generateErrorObjectJsonFail(ex);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
            }
            finally {
                rag.tryCommit();
            }
        }
        return Response.ok((Object)this.resultObject).build();
    }

    @HEAD
    @Path(value="/{id}/{extension: (?!outE)(?!bothE)(?!inE)(?!out)(?!both)(?!in)(?!query).+}")
    @Consumes(value={"application/json"})
    public Response headVertexExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id, JSONObject json) {
        this.setRequestObject(json);
        return this.executeVertexExtension(graphName, id, HttpMethod.HEAD);
    }

    @HEAD
    @Path(value="/{id}/{extension: (?!outE)(?!bothE)(?!inE)(?!out)(?!both)(?!in)(?!query).+}")
    public Response headVertexExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id) {
        return this.executeVertexExtension(graphName, id, HttpMethod.HEAD);
    }

    @PUT
    @Path(value="/{id}/{extension: (?!outE)(?!bothE)(?!inE)(?!out)(?!both)(?!in)(?!query).+}")
    @Consumes(value={"application/json"})
    @Timed(name="http.rest.vertices.extension.put", absolute=true)
    public Response putVertexExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id, JSONObject json) {
        this.setRequestObject(json);
        return this.executeVertexExtension(graphName, id, HttpMethod.PUT);
    }

    @PUT
    @Path(value="/{id}/{extension: (?!outE)(?!bothE)(?!inE)(?!out)(?!both)(?!in)(?!query).+}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Timed(name="http.rest.vertices.extension.put", absolute=true)
    public Response putVertexExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id, MultivaluedMap<String, String> formParams) {
        this.setRequestObject(formParams);
        return this.executeVertexExtension(graphName, id, HttpMethod.PUT);
    }

    @PUT
    @Path(value="/{id}/{extension: (?!outE)(?!bothE)(?!inE)(?!out)(?!both)(?!in)(?!query).+}")
    @Timed(name="http.rest.vertices.extension.put", absolute=true)
    public Response putVertexExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id) {
        return this.executeVertexExtension(graphName, id, HttpMethod.PUT);
    }

    @OPTIONS
    @Path(value="/{id}/{extension: (?!outE)(?!bothE)(?!inE)(?!out)(?!both)(?!in)(?!query).+}")
    @Consumes(value={"application/json"})
    public Response optionsVertexExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id, JSONObject json) {
        this.setRequestObject(json);
        return this.executeVertexExtension(graphName, id, HttpMethod.OPTIONS);
    }

    @OPTIONS
    @Path(value="/{id}/{extension: (?!outE)(?!bothE)(?!inE)(?!out)(?!both)(?!in)(?!query).+}")
    public Response optionsVertexExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id) {
        return this.executeVertexExtension(graphName, id, HttpMethod.OPTIONS);
    }

    @DELETE
    @Path(value="/{id}/{extension: (?!outE)(?!bothE)(?!inE)(?!out)(?!both)(?!in)(?!query).+}")
    @Consumes(value={"application/json"})
    @Timed(name="http.rest.vertices.extension.delete", absolute=true)
    public Response deleteVertexExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id, JSONObject json) {
        this.setRequestObject(json);
        return this.executeVertexExtension(graphName, id, HttpMethod.DELETE);
    }

    @DELETE
    @Path(value="/{id}/{extension: (?!outE)(?!bothE)(?!inE)(?!out)(?!both)(?!in)(?!query).+}")
    @Timed(name="http.rest.vertices.extension.delete", absolute=true)
    public Response deleteVertexExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id) {
        return this.executeVertexExtension(graphName, id, HttpMethod.DELETE);
    }

    @POST
    @Path(value="/{id}/{extension: (?!outE)(?!bothE)(?!inE)(?!out)(?!both)(?!in)(?!query).+}")
    @Consumes(value={"application/json"})
    @Timed(name="http.rest.vertices.extension.post", absolute=true)
    public Response postVertexExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id, JSONObject json) {
        this.setRequestObject(json);
        return this.executeVertexExtension(graphName, id, HttpMethod.POST);
    }

    @POST
    @Path(value="/{id}/{extension: (?!outE)(?!bothE)(?!inE)(?!out)(?!both)(?!in)(?!query).+}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Timed(name="http.rest.vertices.extension.post", absolute=true)
    public Response postVertexExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id, MultivaluedMap<String, String> formParams) {
        this.setRequestObject(formParams);
        return this.executeVertexExtension(graphName, id, HttpMethod.POST);
    }

    @POST
    @Path(value="/{id}/{extension: (?!outE)(?!bothE)(?!inE)(?!out)(?!both)(?!in)(?!query).+}")
    @Timed(name="http.rest.vertices.extension.post", absolute=true)
    public Response postVertexExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id) {
        return this.executeVertexExtension(graphName, id, HttpMethod.POST);
    }

    @GET
    @Path(value="/{id}/{extension: (?!outE)(?!bothE)(?!inE)(?!out)(?!both)(?!in)(?!query).+}")
    @Timed(name="http.rest.vertices.extension.get", absolute=true)
    public Response getVertexExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id) {
        return this.executeVertexExtension(graphName, id, HttpMethod.GET);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response executeVertexExtension(String graphName, String id, HttpMethod httpMethodRequested) {
        Object returnValue;
        ExtensionMethod methodToCall;
        Vertex vertex = this.getRexsterApplicationGraph(graphName).getGraph().getVertex((Object)id);
        ExtensionSegmentSet extensionSegmentSet = this.parseUriForExtensionSegment(graphName, ExtensionPoint.VERTEX);
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        if (!rag.isExtensionAllowed(extensionSegmentSet)) {
            logger.error((Object)("The [" + extensionSegmentSet + "] extension was not configured for [" + graphName + "]"));
            JSONObject error = this.generateErrorObject("The [" + extensionSegmentSet + "] extension was not configured for [" + graphName + "]");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        try {
            List<RexsterExtension> rexsterExtensions;
            try {
                rexsterExtensions = VertexResource.findExtensionClasses(extensionSegmentSet);
            }
            catch (ServiceConfigurationError sce) {
                logger.error((Object)"ServiceLoader could not find a class referenced in com.tinkerpop.rexster.extension.RexsterExtension.");
                JSONObject error = this.generateErrorObject("Class specified in com.tinkerpop.rexster.extension.RexsterExtension could not be found.", sce);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build());
            }
            if (rexsterExtensions == null || rexsterExtensions.size() == 0) {
                logger.error((Object)("The [" + extensionSegmentSet + "] extension was not found for [" + graphName + "].  Check com.tinkerpop.rexster.extension.RexsterExtension file in META-INF.services."));
                JSONObject error = this.generateErrorObject("The [" + extensionSegmentSet + "] extension was not found for [" + graphName + "]");
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build());
            }
            methodToCall = VertexResource.findExtensionMethod(rexsterExtensions, ExtensionPoint.VERTEX, extensionSegmentSet.getExtensionMethod(), httpMethodRequested);
            if (methodToCall == null) {
                if (httpMethodRequested == HttpMethod.OPTIONS) {
                    return this.buildOptionsResponse();
                }
                logger.error((Object)("The [" + extensionSegmentSet + "] extension was not found for [" + graphName + "] with a HTTP method of [" + httpMethodRequested.name() + "].  Check com.tinkerpop.rexster.extension.RexsterExtension file in META-INF.services."));
                JSONObject error = this.generateErrorObject("The [" + extensionSegmentSet + "] extension was not found for [" + graphName + "] with a HTTP method of [" + httpMethodRequested.name() + "]");
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build());
            }
            returnValue = this.invokeExtension(rag, methodToCall, vertex);
        }
        catch (WebApplicationException wae) {
            rag.tryRollback();
            throw wae;
        }
        catch (Exception ex) {
            logger.error((Object)("Dynamic invocation of the [" + extensionSegmentSet + "] extension failed."), (Throwable)ex);
            if (ex.getCause() != null) {
                Throwable cause = ex.getCause();
                logger.error((Object)("It would be smart to trap this this exception within the extension and supply a good response to the user:" + cause.getMessage()), cause);
            }
            rag.tryRollback();
            JSONObject error = this.generateErrorObjectJsonFail(ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        if (!(returnValue instanceof ExtensionResponse)) {
            logger.error((Object)("The [" + extensionSegmentSet + "] extension does not return an ExtensionResponse."));
            JSONObject error = this.generateErrorObject("The [" + extensionSegmentSet + "] extension does not return an ExtensionResponse.");
            rag.tryRollback();
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        ExtensionResponse extResponse = (ExtensionResponse)returnValue;
        if (extResponse.isErrorResponse()) {
            logger.warn((Object)("The [" + extensionSegmentSet + "] extension raised an error response."));
            if (methodToCall.getExtensionDefinition().autoCommitTransaction()) {
                rag.tryRollback();
            }
            throw new WebApplicationException(Response.fromResponse((Response)extResponse.getJerseyResponse()).build());
        }
        if (methodToCall.getExtensionDefinition().autoCommitTransaction()) {
            rag.tryCommit();
        }
        String mediaType = "application/json";
        if (methodToCall != null) {
            mediaType = methodToCall.getExtensionDefinition().produces();
            extResponse = this.tryAppendRexsterAttributesIfJson(extResponse, methodToCall, mediaType);
        }
        return Response.fromResponse((Response)extResponse.getJerseyResponse()).type(mediaType).build();
    }

    @OPTIONS
    @Path(value="/{id}/{direction}")
    public Response optionsVertexEdges() {
        return this.buildOptionsResponse();
    }

    @GET
    @Path(value="/{id}/{direction}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json"})
    @Timed(name="http.rest.vertices.object.edges.collection.get", absolute=true)
    public Response getVertexEdges(@PathParam(value="graphname") String graphName, @PathParam(value="id") String vertexId, @PathParam(value="direction") String direction) {
        return this.getVertexEdges(graphName, vertexId, direction, false);
    }

    @GET
    @Path(value="/{id}/{direction}")
    @Produces(value={"application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.vertices.object.edges.collection.get", absolute=true)
    public Response getVertexEdgesRexsterTypedJson(@PathParam(value="graphname") String graphName, @PathParam(value="id") String vertexId, @PathParam(value="direction") String direction) {
        return this.getVertexEdges(graphName, vertexId, direction, true);
    }

    private Response getVertexEdges(String graphName, String vertexId, String direction, boolean showTypes) {
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        try {
            int limitTake;
            Vertex vertex = rag.getGraph().getVertex((Object)vertexId);
            if (vertex == null) {
                String msg = "Vertex with [" + vertexId + "] cannot be found.";
                logger.info((Object)msg);
                JSONObject error = this.generateErrorObject(msg);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build());
            }
            GraphSONMode mode = showTypes ? GraphSONMode.EXTENDED : GraphSONMode.NORMAL;
            JSONObject theRequestObject = this.getRequestObject();
            Long start = RequestObjectHelper.getStartOffset((JSONObject)theRequestObject);
            Long end = RequestObjectHelper.getEndOffset((JSONObject)theRequestObject);
            Set returnKeys = RequestObjectHelper.getReturnKeys((JSONObject)theRequestObject);
            String[] labels = VertexResource.getLabelsFromRequest(theRequestObject);
            VertexQueryArguments queryArguments = new VertexQueryArguments(direction);
            boolean countOnly = queryArguments.isCountOnly();
            ReturnType returnType = queryArguments.getReturnType();
            Direction queryDirection = queryArguments.getQueryDirection();
            long counter = 0L;
            JSONArray elementArray = new JSONArray();
            VertexQuery query = vertex.query().direction(queryDirection);
            if (labels != null) {
                query = query.labels(labels);
            }
            RequestObjectHelper.buildQueryProperties((JSONObject)theRequestObject, (VertexQuery)query);
            int n = limitTake = theRequestObject.has("_take") ? theRequestObject.getInt("_take") : Integer.MIN_VALUE;
            if (limitTake >= 0) {
                query = query.limit(limitTake);
            }
            if (returnType == ReturnType.VERTICES || returnType == ReturnType.VERTEX_IDS) {
                Iterable vertexQueryResults = query.vertices();
                for (Vertex v : vertexQueryResults) {
                    if (counter >= start && counter < end) {
                        if (returnType.equals((Object)ReturnType.VERTICES)) {
                            elementArray.put((Object)GraphSONUtility.jsonFromElement((Element)v, (Set)returnKeys, (GraphSONMode)mode));
                        } else {
                            elementArray.put(v.getId());
                        }
                    }
                    ++counter;
                }
            } else if (returnType == ReturnType.EDGES) {
                Iterable edgeQueryResults = query.edges();
                for (Edge e : edgeQueryResults) {
                    if (counter >= start && counter < end) {
                        elementArray.put((Object)GraphSONUtility.jsonFromElement((Element)e, (Set)returnKeys, (GraphSONMode)mode));
                    }
                    ++counter;
                }
            } else if (returnType == ReturnType.COUNT) {
                counter = query.count();
            } else {
                JSONObject error = this.generateErrorObject(direction + " direction segment was invalid.");
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build());
            }
            if (!countOnly) {
                this.resultObject.put("results", (Object)elementArray);
            }
            this.resultObject.put("totalSize", counter);
            this.resultObject.put("queryTime", this.sh.stopWatch());
        }
        catch (JSONException ex) {
            logger.error((Object)ex);
            JSONObject error = this.generateErrorObjectJsonFail(ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception re) {
            logger.error((Object)re);
            JSONObject error = this.generateErrorObject(re.getMessage(), re);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        finally {
            rag.tryCommit();
        }
        return Response.ok((Object)this.resultObject).build();
    }

    @POST
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Consumes(value={"application/json", "application/vnd.rexster-v1+json"})
    @Timed(name="http.rest.vertices.object.post", absolute=true)
    public Response postNullVertexRexsterConsumesJson(@Context Request request, @PathParam(value="graphname") String graphName, JSONObject json) {
        this.setRequestObject(json);
        Variant v = request.selectVariant(this.producesVariantList);
        return this.postVertex(graphName, null, false, v);
    }

    @POST
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Consumes(value={"application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.vertices.object.post", absolute=true)
    public Response postNullVertexRexsterConsumesTypedJson(@Context Request request, @PathParam(value="graphname") String graphName, JSONObject json) {
        this.setRequestObject(json);
        Variant v = request.selectVariant(this.producesVariantList);
        return this.postVertex(graphName, null, true, v);
    }

    @POST
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.vertices.object.post", absolute=true)
    public Response postNullVertexOnUri(@Context Request request, @PathParam(value="graphname") String graphName) {
        Variant v = request.selectVariant(this.producesVariantList);
        return this.postVertex(graphName, null, true, v);
    }

    @POST
    @Path(value="/{id}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Consumes(value={"application/json", "application/vnd.rexster-v1+json"})
    @Timed(name="http.rest.vertices.object.post", absolute=true)
    public Response postVertexConsumesJson(@Context Request request, @PathParam(value="graphname") String graphName, @PathParam(value="id") String id, JSONObject json) {
        this.setRequestObject(json);
        Variant v = request.selectVariant(this.producesVariantList);
        return this.postVertex(graphName, id, false, v);
    }

    @POST
    @Path(value="/{id}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Consumes(value={"application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.vertices.object.post", absolute=true)
    public Response postVertexRexsterConsumesTypedJson(@Context Request request, @PathParam(value="graphname") String graphName, @PathParam(value="id") String id, JSONObject json) {
        this.setRequestObject(json);
        Variant v = request.selectVariant(this.producesVariantList);
        return this.postVertex(graphName, id, true, v);
    }

    @POST
    @Path(value="/{id}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.vertices.object.post", absolute=true)
    public Response postVertexOnUri(@Context Request request, @PathParam(value="graphname") String graphName, @PathParam(value="id") String id) {
        Variant v = request.selectVariant(this.producesVariantList);
        return this.postVertex(graphName, id, true, v);
    }

    private Response postVertex(String graphName, String id, boolean parseTypes, Variant variant) {
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        Graph graph = rag.getGraph();
        MediaType produces = variant.getMediaType();
        boolean showTypes = produces.equals((Object)RexsterMediaType.APPLICATION_REXSTER_TYPED_JSON_TYPE);
        boolean showHypermedia = produces.equals((Object)RexsterMediaType.APPLICATION_REXSTER_TYPED_JSON_TYPE) || produces.equals((Object)RexsterMediaType.APPLICATION_REXSTER_JSON_TYPE);
        try {
            JSONArray extensionsList;
            Vertex vertex = id == null ? null : graph.getVertex((Object)id);
            JSONObject theRequestObject = this.getRequestObject();
            if (null == vertex) {
                vertex = graph.addVertex((Object)id);
            } else if (!RequestObjectHelper.hasElementProperties((JSONObject)theRequestObject)) {
                JSONObject error = this.generateErrorObjectJsonFail(new Exception("Vertex with id " + id + " already exists"));
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)error).build());
            }
            Iterator keys = theRequestObject.keys();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                if (key.startsWith("_")) continue;
                vertex.setProperty(key, ElementHelper.getTypedPropertyValue((Object)theRequestObject.get(key), (boolean)parseTypes));
            }
            GraphSONMode mode = showTypes ? GraphSONMode.EXTENDED : GraphSONMode.NORMAL;
            Set returnKeys = RequestObjectHelper.getReturnKeys((JSONObject)theRequestObject);
            JSONObject elementJson = GraphSONUtility.jsonFromElement((Element)vertex, (Set)returnKeys, (GraphSONMode)mode);
            rag.tryCommit();
            elementJson.put("_id", vertex.getId());
            this.resultObject.put("results", (Object)elementJson);
            if (showHypermedia && (extensionsList = rag.getExtensionHypermedia(ExtensionPoint.VERTEX, this.getUriPath())) != null) {
                this.resultObject.put("extensions", (Object)extensionsList);
            }
            this.resultObject.put("queryTime", this.sh.stopWatch());
        }
        catch (JSONException ex) {
            rag.tryRollback();
            logger.error((Object)ex);
            JSONObject error = this.generateErrorObjectJsonFail(ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        catch (Exception re) {
            rag.tryRollback();
            logger.error((Object)re);
            JSONObject error = this.generateErrorObject(re.getMessage(), re);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        return Response.ok((Object)this.resultObject).build();
    }

    @PUT
    @Path(value="/{id}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Consumes(value={"application/json", "application/vnd.rexster-v1+json"})
    @Timed(name="http.rest.vertices.object.put", absolute=true)
    public Response putVertexConsumesJson(@Context Request request, @PathParam(value="graphname") String graphName, @PathParam(value="id") String id, JSONObject json) {
        this.setRequestObject(json);
        Variant v = request.selectVariant(this.producesVariantList);
        return this.putVertex(graphName, id, false, v);
    }

    @PUT
    @Path(value="/{id}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Consumes(value={"application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.vertices.object.put", absolute=true)
    public Response putVertexConsumesTypedJson(@Context Request request, @PathParam(value="graphname") String graphName, @PathParam(value="id") String id, JSONObject json) {
        this.setRequestObject(json);
        Variant v = request.selectVariant(this.producesVariantList);
        return this.putVertex(graphName, id, true, v);
    }

    @PUT
    @Path(value="/{id}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.vertices.object.put", absolute=true)
    public Response putVertexConsumesUri(@Context Request request, @PathParam(value="graphname") String graphName, @PathParam(value="id") String id) {
        Variant v = request.selectVariant(this.producesVariantList);
        return this.putVertex(graphName, id, true, v);
    }

    private Response putVertex(String graphName, String id, boolean parseTypes, Variant variant) {
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        Graph graph = rag.getGraph();
        MediaType produces = variant.getMediaType();
        boolean showTypes = produces.equals((Object)RexsterMediaType.APPLICATION_REXSTER_TYPED_JSON_TYPE);
        boolean showHypermedia = produces.equals((Object)RexsterMediaType.APPLICATION_REXSTER_TYPED_JSON_TYPE) || produces.equals((Object)RexsterMediaType.APPLICATION_REXSTER_JSON_TYPE);
        try {
            JSONArray extensionsList;
            final Vertex vertex = graph.getVertex((Object)id);
            if (null == vertex) {
                String msg = "Vertex with [" + id + "] cannot be found.";
                logger.info((Object)msg);
                JSONObject error = this.generateErrorObject(msg);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build());
            }
            com.tinkerpop.blueprints.util.ElementHelper.removeProperties((Iterable)new ArrayList<Element>(){
                {
                    this.add(vertex);
                }
            });
            JSONObject theRequestObject = this.getRequestObject();
            Iterator keys = theRequestObject.keys();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                if (key.startsWith("_")) continue;
                vertex.setProperty(key, ElementHelper.getTypedPropertyValue((Object)theRequestObject.get(key), (boolean)parseTypes));
            }
            rag.tryCommit();
            Vertex reconstitutedElement = graph.getVertex(vertex.getId());
            GraphSONMode mode = showTypes ? GraphSONMode.EXTENDED : GraphSONMode.NORMAL;
            Set returnKeys = RequestObjectHelper.getReturnKeys((JSONObject)theRequestObject);
            this.resultObject.put("results", (Object)GraphSONUtility.jsonFromElement((Element)reconstitutedElement, (Set)returnKeys, (GraphSONMode)mode));
            if (showHypermedia && (extensionsList = rag.getExtensionHypermedia(ExtensionPoint.VERTEX, this.getUriPath())) != null) {
                this.resultObject.put("extensions", (Object)extensionsList);
            }
            this.resultObject.put("queryTime", this.sh.stopWatch());
        }
        catch (JSONException ex) {
            rag.tryRollback();
            logger.error((Object)ex);
            JSONObject error = this.generateErrorObjectJsonFail(ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        catch (Exception re) {
            rag.tryRollback();
            logger.error((Object)re);
            JSONObject error = this.generateErrorObject(re.getMessage(), re);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        return Response.ok((Object)this.resultObject).build();
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.vertices.object.delete", absolute=true)
    public Response deleteVertex(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id) {
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        Graph graph = rag.getGraph();
        try {
            List<String> keys = this.getNonRexsterRequestKeys();
            Vertex vertex = graph.getVertex((Object)id);
            if (null != vertex) {
                if (keys.size() > 0) {
                    for (String key : keys) {
                        vertex.removeProperty(key);
                    }
                } else {
                    graph.removeVertex(vertex);
                }
            } else {
                String msg = "Vertex with [" + id + "] cannot be found.";
                logger.info((Object)msg);
                JSONObject error = this.generateErrorObject(msg);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build());
            }
            rag.tryCommit();
            this.resultObject.put("queryTime", this.sh.stopWatch());
        }
        catch (JSONException ex) {
            rag.tryRollback();
            logger.error((Object)ex);
            JSONObject error = this.generateErrorObjectJsonFail(ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        catch (Exception re) {
            rag.tryRollback();
            logger.error((Object)re);
            JSONObject error = this.generateErrorObject(re.getMessage(), re);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        return Response.ok((Object)this.resultObject).build();
    }

    private static String[] getLabelsFromRequest(JSONObject theRequestObject) {
        String oneLabel;
        JSONArray labelSet = theRequestObject.optJSONArray("_label");
        if (labelSet == null && (oneLabel = theRequestObject.optString("_label")) != null && !oneLabel.isEmpty()) {
            labelSet = new JSONArray();
            labelSet.put((Object)oneLabel);
        }
        String[] labels = null;
        if (labelSet != null) {
            labels = new String[labelSet.length()];
            for (int ix = 0; ix < labelSet.length(); ++ix) {
                labels[ix] = labelSet.optString(ix);
            }
        }
        return labels;
    }

    private final class VertexQueryArguments {
        private final Direction queryDirection;
        private final ReturnType returnType;
        private final boolean countOnly;

        public VertexQueryArguments(String directionSegment) {
            if (directionSegment.equals("outE")) {
                this.returnType = ReturnType.EDGES;
                this.queryDirection = Direction.OUT;
                this.countOnly = false;
            } else if (directionSegment.equals("inE")) {
                this.returnType = ReturnType.EDGES;
                this.queryDirection = Direction.IN;
                this.countOnly = false;
            } else if (directionSegment.equals("bothE")) {
                this.returnType = ReturnType.EDGES;
                this.queryDirection = Direction.BOTH;
                this.countOnly = false;
            } else if (directionSegment.equals("out")) {
                this.returnType = ReturnType.VERTICES;
                this.queryDirection = Direction.OUT;
                this.countOnly = false;
            } else if (directionSegment.equals("in")) {
                this.returnType = ReturnType.VERTICES;
                this.queryDirection = Direction.IN;
                this.countOnly = false;
            } else if (directionSegment.equals("both")) {
                this.returnType = ReturnType.VERTICES;
                this.queryDirection = Direction.BOTH;
                this.countOnly = false;
            } else if (directionSegment.equals("bothCount")) {
                this.returnType = ReturnType.COUNT;
                this.queryDirection = Direction.BOTH;
                this.countOnly = true;
            } else if (directionSegment.equals("inCount")) {
                this.returnType = ReturnType.COUNT;
                this.queryDirection = Direction.IN;
                this.countOnly = true;
            } else if (directionSegment.equals("outCount")) {
                this.returnType = ReturnType.COUNT;
                this.queryDirection = Direction.OUT;
                this.countOnly = true;
            } else if (directionSegment.equals("bothIds")) {
                this.returnType = ReturnType.VERTEX_IDS;
                this.queryDirection = Direction.BOTH;
                this.countOnly = false;
            } else if (directionSegment.equals("inIds")) {
                this.returnType = ReturnType.VERTEX_IDS;
                this.queryDirection = Direction.IN;
                this.countOnly = false;
            } else if (directionSegment.equals("outIds")) {
                this.returnType = ReturnType.VERTEX_IDS;
                this.queryDirection = Direction.OUT;
                this.countOnly = false;
            } else {
                JSONObject error = VertexResource.this.generateErrorObject(directionSegment + " segment was invalid.");
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build());
            }
        }

        public Direction getQueryDirection() {
            return this.queryDirection;
        }

        public ReturnType getReturnType() {
            return this.returnType;
        }

        public boolean isCountOnly() {
            return this.countOnly;
        }
    }

    private static enum ReturnType {
        VERTICES,
        EDGES,
        COUNT,
        VERTEX_IDS;

    }
}

