/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.DiscoverProjectStructure;
import org.jboss.windup.config.phase.RulePhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.ProjectService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.rules.apps.java.scan.provider.DiscoverNonMavenArchiveProjectsRuleProvider;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class DiscoverNonMavenSourceProjectsRuleProvider
extends WindupRuleProvider {
    public Class<? extends RulePhase> getPhase() {
        return DiscoverProjectStructure.class;
    }

    public List<Class<? extends WindupRuleProvider>> getExecuteAfter() {
        return this.asClassList(new Class[]{DiscoverNonMavenArchiveProjectsRuleProvider.class});
    }

    public Configuration getConfiguration(GraphContext arg0) {
        return ConfigurationBuilder.begin().addRule().perform((Operation)new AddProjectInformation());
    }

    public String toString() {
        return "AddProjectInformation";
    }

    private class AddProjectInformation
    extends GraphOperation {
        private AddProjectInformation() {
        }

        public void perform(GraphRewrite event, EvaluationContext context) {
            WindupConfigurationModel cfg = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
            FileModel mainFileModel = cfg.getInputPath();
            ProjectService projectModelService = new ProjectService(event.getGraphContext());
            ProjectModel mainProjectModel = mainFileModel.getProjectModel();
            if (mainProjectModel == null) {
                mainProjectModel = (ProjectModel)projectModelService.create();
                mainProjectModel.setName(mainFileModel.getFileName());
                mainProjectModel.setDescription("Source Directory");
                mainFileModel.setProjectModel(mainProjectModel);
                mainProjectModel.setRootFileModel(mainFileModel);
                mainProjectModel.addFileModel(mainFileModel);
            }
            this.addProjectToChildFiles(mainFileModel, mainProjectModel);
        }

        private void addProjectToChildFiles(FileModel fileModel, ProjectModel projectModel) {
            for (FileModel childFile : fileModel.getFilesInDirectory()) {
                if (childFile.getProjectModel() == null) {
                    projectModel.addFileModel(childFile);
                    childFile.setProjectModel(projectModel);
                } else if (childFile.getProjectModel().getParentProject() == null && !childFile.getProjectModel().equals(projectModel)) {
                    childFile.getProjectModel().setParentProject(projectModel);
                }
                this.addProjectToChildFiles(childFile, projectModel);
            }
        }

        public String toString() {
            return "ScanAsNonMavenProject";
        }
    }
}

