/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.xml;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.rules.apps.java.condition.JavaClass;
import org.jboss.windup.rules.apps.java.condition.JavaClassBuilder;
import org.jboss.windup.rules.apps.java.condition.JavaClassBuilderAt;
import org.jboss.windup.rules.apps.java.scan.ast.TypeReferenceLocation;
import org.jboss.windup.util.exception.WindupException;
import org.joox.JOOX;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="javaclass", namespace="http://windup.jboss.org/v1/xml")
public class JavaClassHandler
implements ElementHandler<JavaClassBuilderAt> {
    public static final String ELEM_NAME = "javaclass";
    private static final String ATTR_REFERENCES = "references";

    public JavaClassBuilderAt processElement(ParserContext handlerManager, Element element) throws ConfigurationException {
        String type = JOOX.$((Element)element).attr(ATTR_REFERENCES);
        String as = JOOX.$((Element)element).attr("as");
        String from = JOOX.$((Element)element).attr("from");
        if (StringUtils.isBlank((String)type)) {
            throw new WindupException("The 'javaclass' element must have a non-empty 'references' attribute");
        }
        ArrayList<TypeReferenceLocation> locations = new ArrayList<TypeReferenceLocation>();
        List children = JOOX.$((Element)element).children("location").get();
        for (Element child : children) {
            TypeReferenceLocation location = (TypeReferenceLocation)((Object)handlerManager.processElement(child));
            locations.add(location);
        }
        JavaClassBuilder javaClassReferences = from != null ? JavaClass.from(from).references(type) : JavaClass.references(type);
        String namePattern = JOOX.$((Element)element).attr("in");
        if (!StringUtils.isBlank((String)namePattern)) {
            javaClassReferences.inType(namePattern);
        }
        JavaClassBuilderAt javaClass = javaClassReferences.at(locations.toArray(new TypeReferenceLocation[locations.size()]));
        if (as != null) {
            javaClass.as(as);
        }
        return javaClass;
    }
}

