/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.command;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.addon.shell.spi.command.CdTokenHandler;
import org.jboss.forge.addon.shell.spi.command.CdTokenHandlerFactory;
import org.jboss.forge.furnace.container.cdi.events.Local;
import org.jboss.forge.furnace.event.PreShutdown;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.spi.ListenerRegistration;

@Singleton
public class CdTokenHandlerFactoryImpl
implements CdTokenHandlerFactory {
    @Inject
    private Imported<CdTokenHandler> importedHandlers;
    private List<CdTokenHandler> manuallyRegisteredHandlers = new ArrayList<CdTokenHandler>();

    public void shutdown(@Observes @Local PreShutdown shutdown) {
        this.manuallyRegisteredHandlers.clear();
    }

    public List<CdTokenHandler> getHandlers() {
        ArrayList<CdTokenHandler> result = new ArrayList<CdTokenHandler>();
        for (CdTokenHandler cdTokenHandler : this.importedHandlers) {
            result.add(cdTokenHandler);
        }
        result.addAll(this.manuallyRegisteredHandlers);
        return result;
    }

    public ListenerRegistration<CdTokenHandler> addTokenHandler(final CdTokenHandler handler) {
        this.manuallyRegisteredHandlers.add(handler);
        return new ListenerRegistration<CdTokenHandler>(){

            public CdTokenHandler removeListener() {
                CdTokenHandlerFactoryImpl.this.manuallyRegisteredHandlers.remove(handler);
                return handler;
            }
        };
    }
}

