/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.parameters.ParameterizedIterationOperation;
import org.jboss.windup.graph.model.resource.SourceFileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.config.HintBuilderIn;
import org.jboss.windup.reporting.config.HintBuilderTitle;
import org.jboss.windup.reporting.config.HintLink;
import org.jboss.windup.reporting.config.HintText;
import org.jboss.windup.reporting.config.Link;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.reporting.model.LinkModel;
import org.jboss.windup.rules.files.model.FileLocationModel;
import org.ocpsoft.rewrite.config.OperationBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;

public class Hint
extends ParameterizedIterationOperation<FileLocationModel>
implements HintText,
HintLink {
    private static final Logger log = Logger.getLogger(Hint.class.getName());
    private RegexParameterizedPatternParser hintTitlePattern;
    private RegexParameterizedPatternParser hintTextPattern;
    private int effort;
    private List<Link> links = new ArrayList<Link>();

    protected Hint(String variable) {
        super(variable);
    }

    protected Hint() {
    }

    public static HintBuilderIn in(String fileVariable) {
        return new HintBuilderIn(fileVariable);
    }

    public static HintBuilderTitle titled(String title) {
        return new HintBuilderTitle(title);
    }

    public static HintText withText(String text) {
        Assert.notNull((Object)text, (String)"Hint text must not be null.");
        Hint hint = new Hint();
        hint.setText(text);
        return hint;
    }

    public void performParameterized(GraphRewrite event, EvaluationContext context, FileLocationModel locationModel) {
        GraphService service = new GraphService(event.getGraphContext(), InlineHintModel.class);
        InlineHintModel hintModel = (InlineHintModel)service.create();
        hintModel.setLineNumber(locationModel.getLineNumber());
        hintModel.setColumnNumber(locationModel.getColumnNumber());
        hintModel.setLength(locationModel.getLength());
        hintModel.setFileLocationReference(locationModel);
        hintModel.setFile(locationModel.getFile());
        hintModel.setEffort(this.effort);
        if (this.hintTitlePattern != null) {
            hintModel.setTitle(this.hintTitlePattern.getBuilder().build((Rewrite)event, context));
        } else {
            hintModel.setTitle(locationModel.getDescription());
        }
        hintModel.setHint(this.hintTextPattern.getBuilder().build((Rewrite)event, context));
        GraphService linkService = new GraphService(event.getGraphContext(), LinkModel.class);
        for (Link link : this.links) {
            LinkModel linkModel = (LinkModel)linkService.create();
            linkModel.setDescription(link.getDescription());
            linkModel.setLink(link.getLink());
            hintModel.addLink(linkModel);
        }
        if (locationModel.getFile() instanceof SourceFileModel) {
            ((SourceFileModel)locationModel.getFile()).setGenerateSourceReport(true);
        }
        log.info("Hint added to " + locationModel.getFile().getPrettyPathWithinProject() + " [" + this + "] ");
    }

    @Override
    public OperationBuilder withEffort(int effort) {
        this.effort = effort;
        return this;
    }

    @Override
    public HintLink with(Link link) {
        this.links.add(link);
        return this;
    }

    protected void setText(String text) {
        this.hintTextPattern = new RegexParameterizedPatternParser(text);
    }

    protected void setTitle(String title) {
        this.hintTitlePattern = new RegexParameterizedPatternParser(title);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Hint");
        if (this.hintTitlePattern != null) {
            result.append(".titled(\"").append(this.hintTitlePattern.getPattern()).append("\")");
        }
        result.append(".withText(\"" + this.hintTextPattern.getPattern() + "\")");
        if (this.effort != 0) {
            result.append(".withEffort(" + this.effort + ")");
        }
        if (this.links != null && !this.links.isEmpty()) {
            result.append(".with(" + this.links + ")");
        }
        return result.toString();
    }

    public RegexParameterizedPatternParser getHintText() {
        return this.hintTextPattern;
    }

    public int getEffort() {
        return this.effort;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public Set<String> getRequiredParameterNames() {
        return this.hintTextPattern.getRequiredParameterNames();
    }

    public void setParameterStore(ParameterStore store) {
        this.hintTextPattern.setParameterStore(store);
    }
}

