/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.util;

import java.io.File;

public final class OperatingSystemUtils {
    private static boolean PRETEND_WINDOWS = Boolean.getBoolean("forge.pretend_windows");
    private static String operatingSystem = null;
    private static final int TEMP_DIR_ATTEMPTS = 10000;

    public static String getOsName() {
        if (operatingSystem == null) {
            operatingSystem = System.getProperty("os.name").toLowerCase();
        }
        return operatingSystem;
    }

    public static boolean isWindows() {
        return PRETEND_WINDOWS || OperatingSystemUtils.getOsName().startsWith("windows");
    }

    public static boolean isOSX() {
        return OperatingSystemUtils.getOsName().startsWith("mac");
    }

    public static boolean isLinux() {
        return OperatingSystemUtils.getOsName().startsWith("linux");
    }

    public static File getWorkingDir() {
        return new File(System.getProperty("user.dir"));
    }

    public static File getForgeHomeDir() {
        return new File(System.getProperty("forge.home")).getAbsoluteFile();
    }

    public static File getUserHomeDir() {
        return new File(System.getProperty("user.home")).getAbsoluteFile();
    }

    public static String getUserHomePath() {
        return OperatingSystemUtils.getUserHomeDir().getAbsolutePath();
    }

    public static File getUserForgeDir() {
        return new File(OperatingSystemUtils.getUserHomeDir(), ".forge").getAbsoluteFile();
    }

    public static void setPretendWindows(boolean value) {
        PRETEND_WINDOWS = value;
    }

    public static String getLineSeparator() {
        return System.lineSeparator();
    }

    public static String getSafeFilename(String filename) {
        String result = filename;
        if (result != null) {
            result = result.replaceAll("[^a-zA-Z0-9]+", "-").replaceAll("^-+", "");
        }
        return result;
    }

    public static File createTempDir() {
        File baseDir = OperatingSystemUtils.getTempDirectory();
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
    }

    public static File getTempDirectory() {
        return new File(System.getProperty("java.io.tmpdir"));
    }
}

