/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.frames;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.wrappers.WrapperGraph;
import com.tinkerpop.frames.EdgeFrame;
import com.tinkerpop.frames.FrameInitializer;
import com.tinkerpop.frames.FramedElement;
import com.tinkerpop.frames.FramedGraphConfiguration;
import com.tinkerpop.frames.FramedGraphQuery;
import com.tinkerpop.frames.VertexFrame;
import com.tinkerpop.frames.annotations.AdjacencyAnnotationHandler;
import com.tinkerpop.frames.annotations.AnnotationHandler;
import com.tinkerpop.frames.annotations.DomainAnnotationHandler;
import com.tinkerpop.frames.annotations.InVertexAnnotationHandler;
import com.tinkerpop.frames.annotations.IncidenceAnnotationHandler;
import com.tinkerpop.frames.annotations.OutVertexAnnotationHandler;
import com.tinkerpop.frames.annotations.PropertyMethodHandler;
import com.tinkerpop.frames.annotations.RangeAnnotationHandler;
import com.tinkerpop.frames.annotations.gremlin.GremlinGroovyAnnotationHandler;
import com.tinkerpop.frames.core.FramedGraphQueryImpl;
import com.tinkerpop.frames.modules.TypeResolver;
import com.tinkerpop.frames.structures.FramedEdgeIterable;
import com.tinkerpop.frames.structures.FramedVertexIterable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public class FramedGraph<T extends Graph>
implements Graph,
WrapperGraph<T> {
    protected final T baseGraph;
    private FramedGraphConfiguration config;
    private boolean configViaFactory;

    protected FramedGraph(T baseGraph, FramedGraphConfiguration config) {
        this.config = config;
        this.baseGraph = baseGraph;
        this.configViaFactory = true;
    }

    public FramedGraph(T baseGraph) {
        this.baseGraph = baseGraph;
        this.config = new FramedGraphConfiguration();
        this.config.setConfiguredGraph((Graph)baseGraph);
        this.configViaFactory = false;
        this.config.addMethodHandler(new PropertyMethodHandler());
        this.registerAnnotationHandler(new AdjacencyAnnotationHandler());
        this.registerAnnotationHandler(new IncidenceAnnotationHandler());
        this.registerAnnotationHandler(new DomainAnnotationHandler());
        this.registerAnnotationHandler(new RangeAnnotationHandler());
        this.registerAnnotationHandler(new InVertexAnnotationHandler());
        this.registerAnnotationHandler(new OutVertexAnnotationHandler());
        this.registerAnnotationHandler(new GremlinGroovyAnnotationHandler());
    }

    public <F> F frame(Vertex vertex, Class<F> kind) {
        if (vertex == null) {
            return null;
        }
        HashSet resolvedTypes = new HashSet();
        resolvedTypes.add(VertexFrame.class);
        resolvedTypes.add(kind);
        for (TypeResolver typeResolver : this.config.getTypeResolvers()) {
            resolvedTypes.addAll(Arrays.asList(typeResolver.resolveTypes(vertex, kind)));
        }
        return (F)Proxy.newProxyInstance(this.config.getFrameClassLoaderResolver().resolveClassLoader(kind), resolvedTypes.toArray(new Class[resolvedTypes.size()]), (InvocationHandler)new FramedElement(this, (Element)vertex));
    }

    public <F> F frame(Edge edge, Direction direction, Class<F> kind) {
        if (edge == null) {
            return null;
        }
        HashSet resolvedTypes = new HashSet();
        resolvedTypes.add(EdgeFrame.class);
        resolvedTypes.add(kind);
        for (TypeResolver typeResolver : this.config.getTypeResolvers()) {
            resolvedTypes.addAll(Arrays.asList(typeResolver.resolveTypes(edge, kind)));
        }
        return (F)Proxy.newProxyInstance(this.config.getFrameClassLoaderResolver().resolveClassLoader(kind), resolvedTypes.toArray(new Class[resolvedTypes.size()]), (InvocationHandler)new FramedElement(this, (Element)edge, direction));
    }

    public <F> F frame(Edge edge, Class<F> kind) {
        return this.frame(edge, Direction.OUT, kind);
    }

    public <F> Iterable<F> frameVertices(Iterable<Vertex> vertices, Class<F> kind) {
        return new FramedVertexIterable<F>(this, vertices, kind);
    }

    public <F> Iterable<F> frameEdges(Iterable<Edge> edges, Direction direction, Class<F> kind) {
        return new FramedEdgeIterable<F>(this, edges, direction, kind);
    }

    public <F> Iterable<F> frameEdges(Iterable<Edge> edges, Class<F> kind) {
        return new FramedEdgeIterable<F>(this, edges, kind);
    }

    public Vertex getVertex(Object id) {
        return this.config.getConfiguredGraph().getVertex(id);
    }

    public <F> F getVertex(Object id, Class<F> kind) {
        return this.frame(this.getVertex(id), kind);
    }

    public Vertex addVertex(Object id) {
        return this.config.getConfiguredGraph().addVertex(id);
    }

    public <F> F addVertex(Object id, Class<F> kind) {
        Vertex vertex = this.addVertex(id);
        for (FrameInitializer initializer : this.config.getFrameInitializers()) {
            initializer.initElement(kind, this, (Element)vertex);
        }
        return this.frame(vertex, kind);
    }

    public Edge getEdge(Object id) {
        return this.config.getConfiguredGraph().getEdge(id);
    }

    public <F> F getEdge(Object id, Direction direction, Class<F> kind) {
        return this.frame(this.getEdge(id), direction, kind);
    }

    public <F> F getEdge(Object id, Class<F> kind) {
        return this.frame(this.getEdge(id), kind);
    }

    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        return this.config.getConfiguredGraph().addEdge(id, outVertex, inVertex, label);
    }

    public <F> F addEdge(Object id, Vertex outVertex, Vertex inVertex, String label, Direction direction, Class<F> kind) {
        Edge edge = this.addEdge(id, outVertex, inVertex, label);
        for (FrameInitializer initializer : this.config.getFrameInitializers()) {
            initializer.initElement(kind, this, (Element)edge);
        }
        return this.frame(edge, direction, kind);
    }

    public <F> F addEdge(Object id, Vertex outVertex, Vertex inVertex, String label, Class<F> kind) {
        return this.addEdge(id, outVertex, inVertex, label, Direction.OUT, kind);
    }

    public void removeVertex(Vertex vertex) {
        this.config.getConfiguredGraph().removeVertex(vertex);
    }

    public void removeEdge(Edge edge) {
        this.config.getConfiguredGraph().removeEdge(edge);
    }

    public Iterable<Vertex> getVertices() {
        return this.config.getConfiguredGraph().getVertices();
    }

    public Iterable<Vertex> getVertices(String key, Object value) {
        return this.config.getConfiguredGraph().getVertices(key, value);
    }

    public <F> Iterable<F> getVertices(String key, Object value, Class<F> kind) {
        return new FramedVertexIterable<F>(this, this.config.getConfiguredGraph().getVertices(key, value), kind);
    }

    public Iterable<Edge> getEdges() {
        return this.config.getConfiguredGraph().getEdges();
    }

    public Iterable<Edge> getEdges(String key, Object value) {
        return this.config.getConfiguredGraph().getEdges(key, value);
    }

    public <F> Iterable<F> getEdges(String key, Object value, Direction direction, Class<F> kind) {
        return new FramedEdgeIterable<F>(this, this.config.getConfiguredGraph().getEdges(key, value), direction, kind);
    }

    public <F> Iterable<F> getEdges(String key, Object value, Class<F> kind) {
        return new FramedEdgeIterable<F>(this, this.config.getConfiguredGraph().getEdges(key, value), kind);
    }

    public Features getFeatures() {
        Features features = this.config.getConfiguredGraph().getFeatures().copyFeatures();
        features.isWrapper = true;
        return features;
    }

    public void shutdown() {
        this.config.getConfiguredGraph().shutdown();
    }

    public T getBaseGraph() {
        return this.baseGraph;
    }

    public String toString() {
        return StringFactory.graphString((Graph)this, (String)this.baseGraph.toString());
    }

    public void registerAnnotationHandler(AnnotationHandler<? extends Annotation> handler) {
        this.checkFactoryConfig();
        this.config.addAnnotationHandler(handler);
    }

    public AnnotationHandler<?> getAnnotationHandler(Class<? extends Annotation> annotationType) {
        this.checkFactoryConfig();
        return this.config.getAnnotationHandlers().get(annotationType);
    }

    public boolean hasAnnotationHandler(Class<? extends Annotation> annotationType) {
        this.checkFactoryConfig();
        return this.config.getAnnotationHandlers().containsKey(annotationType);
    }

    public void unregisterAnnotationHandler(Class<? extends Annotation> annotationType) {
        this.checkFactoryConfig();
        this.config.getAnnotationHandlers().remove(annotationType);
    }

    public Collection<AnnotationHandler<? extends Annotation>> getAnnotationHandlers() {
        this.checkFactoryConfig();
        return this.config.getAnnotationHandlers().values();
    }

    public void registerFrameInitializer(FrameInitializer frameInitializer) {
        this.checkFactoryConfig();
        this.config.addFrameInitializer(frameInitializer);
    }

    private void checkFactoryConfig() {
        if (this.configViaFactory) {
            throw new UnsupportedOperationException("Unsupported for FramedGraph configured by factory");
        }
    }

    FramedGraphConfiguration getConfig() {
        return this.config;
    }

    public FramedGraphQuery query() {
        return new FramedGraphQueryImpl(this, this.config.getConfiguredGraph().query());
    }
}

