/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.algebra.BNodeGenerator;
import org.openrdf.query.algebra.Distinct;
import org.openrdf.query.algebra.EmptySet;
import org.openrdf.query.algebra.Extension;
import org.openrdf.query.algebra.ExtensionElem;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.MultiProjection;
import org.openrdf.query.algebra.Projection;
import org.openrdf.query.algebra.ProjectionElem;
import org.openrdf.query.algebra.ProjectionElemList;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.Reduced;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Union;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.query.algebra.helpers.StatementPatternCollector;

public class ConstructorBuilder {
    public TupleExpr buildConstructor(TupleExpr bodyExpr, TupleExpr constructExpr, boolean distinct, boolean reduced) {
        return this.buildConstructor(bodyExpr, constructExpr, true, distinct, reduced);
    }

    public TupleExpr buildConstructor(TupleExpr bodyExpr, boolean distinct, boolean reduced) throws MalformedQueryException {
        BasicPatternVerifier verifier = new BasicPatternVerifier();
        bodyExpr.visit((QueryModelVisitor)verifier);
        if (!verifier.isBasicPattern()) {
            throw new MalformedQueryException("can not use shorthand CONSTRUCT: graph pattern in WHERE clause is not a basic pattern.");
        }
        return this.buildConstructor(bodyExpr, bodyExpr, false, distinct, reduced);
    }

    private TupleExpr buildConstructor(TupleExpr bodyExpr, TupleExpr constructExpr, boolean explicitConstructor, boolean distinct, boolean reduced) {
        Object result = bodyExpr;
        List statementPatterns = StatementPatternCollector.process((QueryModelNode)constructExpr);
        Set<Var> constructVars = this.getConstructVars(statementPatterns);
        if (distinct || reduced) {
            ProjectionElemList projElemList = new ProjectionElemList();
            for (Var var : constructVars) {
                if (var.isAnonymous() || var.hasValue()) continue;
                projElemList.addElement(new ProjectionElem(var.getName()));
            }
            result = new Projection(result, projElemList);
            result = distinct ? new Distinct(result) : new Reduced(result);
        }
        HashMap<Var, ExtensionElem> extElemMap = new HashMap<Var, ExtensionElem>();
        for (Var var : constructVars) {
            if (!var.isAnonymous() || extElemMap.containsKey(var)) continue;
            ValueConstant valueExpr = null;
            if (var.hasValue()) {
                valueExpr = new ValueConstant(var.getValue());
            } else if (explicitConstructor) {
                valueExpr = new BNodeGenerator();
            }
            if (valueExpr == null) continue;
            extElemMap.put(var, new ExtensionElem((ValueExpr)valueExpr, var.getName()));
        }
        if (!extElemMap.isEmpty()) {
            result = new Extension(result, extElemMap.values());
        }
        ArrayList<ProjectionElemList> projections = new ArrayList<ProjectionElemList>();
        for (StatementPattern sp : statementPatterns) {
            ProjectionElemList projElemList = new ProjectionElemList();
            projElemList.addElement(new ProjectionElem(sp.getSubjectVar().getName(), "subject"));
            projElemList.addElement(new ProjectionElem(sp.getPredicateVar().getName(), "predicate"));
            projElemList.addElement(new ProjectionElem(sp.getObjectVar().getName(), "object"));
            projections.add(projElemList);
        }
        if (projections.size() == 1) {
            result = new Projection(result, (ProjectionElemList)projections.get(0));
        } else if (projections.size() > 1) {
            result = new MultiProjection(result, projections);
            if (distinct) {
                result = new Distinct(result);
            } else if (reduced) {
                result = new Reduced(result);
            }
        } else {
            result = new EmptySet();
        }
        return result;
    }

    private Set<Var> getConstructVars(Collection<StatementPattern> statementPatterns) {
        LinkedHashSet<Var> vars = new LinkedHashSet<Var>(statementPatterns.size() * 2);
        for (StatementPattern sp : statementPatterns) {
            vars.add(sp.getSubjectVar());
            vars.add(sp.getPredicateVar());
            vars.add(sp.getObjectVar());
        }
        return vars;
    }

    private class BasicPatternVerifier
    extends QueryModelVisitorBase<RuntimeException> {
        private boolean basicPattern = true;

        private BasicPatternVerifier() {
        }

        public boolean isBasicPattern() {
            return this.basicPattern;
        }

        public void meet(LeftJoin node) {
            this.basicPattern = false;
        }

        public void meet(Filter node) {
            this.basicPattern = false;
        }

        public void meet(Extension node) {
            this.basicPattern = false;
        }

        public void meet(Projection node) {
            this.basicPattern = false;
        }

        public void meet(Union node) {
            this.basicPattern = false;
        }

        public void meet(StatementPattern node) {
            if (!StatementPattern.Scope.DEFAULT_CONTEXTS.equals((Object)node.getScope())) {
                this.basicPattern = false;
            } else if (node.getContextVar() != null) {
                this.basicPattern = false;
            } else {
                super.meet(node);
            }
        }
    }
}

