/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree.dupConvert;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.TreeUtils;
import java.nio.ByteBuffer;

public final class DupCountLN
extends LN {
    private static final String BEGIN_TAG = "<dupCountLN>";
    private static final String END_TAG = "</dupCountLN>";
    private int dupCount = 0;

    public int getDupCount() {
        return this.dupCount;
    }

    public boolean containsDuplicates() {
        return true;
    }

    public boolean isDeleted() {
        return false;
    }

    public long getMemorySizeIncludedByParent() {
        return MemoryBudget.DUPCOUNTLN_OVERHEAD;
    }

    public String toString() {
        return this.dumpString(0, true);
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuilder sb = new StringBuilder();
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.beginTag());
            sb.append('\n');
        }
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<count v=\"").append(this.dupCount).append("\"/>").append('\n');
        sb.append(super.dumpString(nSpaces, false));
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.endTag());
        }
        return sb.toString();
    }

    protected LogEntryType getLogType(boolean isInsert, boolean isTransactional) {
        return isTransactional ? LogEntryType.LOG_DUPCOUNTLN_TRANSACTIONAL : LogEntryType.LOG_DUPCOUNTLN;
    }

    public int getLogSize() {
        throw EnvironmentFailureException.unexpectedState();
    }

    public void writeToLog(ByteBuffer logBuffer) {
        throw EnvironmentFailureException.unexpectedState();
    }

    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        super.readFromLog(itemBuffer, entryVersion);
        this.dupCount = LogUtils.readInt(itemBuffer, entryVersion < 6);
    }

    public boolean logicalEquals(Loggable other) {
        return false;
    }

    protected void dumpLogAdditional(StringBuilder sb, boolean verbose) {
        super.dumpLogAdditional(sb, verbose);
        sb.append("<count v=\"").append(this.dupCount).append("\"/>");
    }
}

