/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.facets;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.FacetNotFoundException;
import org.jboss.forge.addon.facets.MutableFacet;
import org.jboss.forge.addon.facets.MutableFaceted;

public abstract class AbstractFaceted<FACETTYPE extends Facet<?>>
implements MutableFaceted<FACETTYPE> {
    private Set<FACETTYPE> facets = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    public boolean hasFacet(Class<? extends FACETTYPE> type) {
        return this.safeGetFacet(type) != null;
    }

    @Override
    public boolean hasAllFacets(Class<? extends FACETTYPE> ... facetDependencies) {
        return this.hasAllFacets(Arrays.asList(facetDependencies));
    }

    @Override
    public boolean hasAllFacets(Iterable<Class<? extends FACETTYPE>> facetDependencies) {
        for (Class<FACETTYPE> clazz : facetDependencies) {
            if (this.hasFacet(clazz)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <F extends FACETTYPE> F getFacet(Class<F> type) throws FacetNotFoundException {
        F facet = this.safeGetFacet(type);
        if (facet == null) {
            throw new FacetNotFoundException("No Facet of type [" + type + "] is installed.");
        }
        return facet;
    }

    @Override
    public Iterable<FACETTYPE> getFacets() {
        return Collections.unmodifiableCollection(this.facets);
    }

    @Override
    public boolean install(FACETTYPE facet) {
        if (facet.getFaceted() != this) {
            throw new IllegalArgumentException("[" + facet + "].getOrigin() was [" + facet.getFaceted() + "] but needed to be [" + this + "]. If your facet type implements " + MutableFacet.class.getSimpleName() + ", " + "ensure that a valid origin was supplied during facet creation.");
        }
        if (this.supports(facet) && (facet.isInstalled() || facet.install())) {
            this.facets.add(facet);
            return true;
        }
        return false;
    }

    @Override
    public boolean register(FACETTYPE facet) {
        if (facet.getFaceted() != this) {
            throw new IllegalArgumentException("[" + facet + "].getOrigin() was [" + facet.getFaceted() + "] but needed to be [" + this + "]. If your facet type implements " + MutableFacet.class.getSimpleName() + ", " + "ensure that a valid origin was supplied during facet creation.");
        }
        if (this.supports(facet) && facet.isInstalled()) {
            this.facets.add(facet);
            return true;
        }
        return false;
    }

    @Override
    public <F extends FACETTYPE> Iterable<F> getFacets(Class<F> type) {
        HashSet<Facet> result = new HashSet<Facet>();
        for (Facet facet : this.facets) {
            if (!type.isInstance(facet)) continue;
            result.add(facet);
        }
        return result;
    }

    private <F extends FACETTYPE> F safeGetFacet(Class<F> type) {
        for (Facet facet : this.facets) {
            if (!type.isInstance(facet)) continue;
            return (F)facet;
        }
        return null;
    }

    @Override
    public boolean uninstall(FACETTYPE facet) {
        return facet.isInstalled() ? facet.uninstall() && this.facets.remove(facet) : !this.facets.contains(facet) || this.facets.remove(facet);
    }

    @Override
    public boolean unregister(FACETTYPE facet) {
        return facet.isInstalled() ? false : this.facets.remove(facet);
    }
}

