/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.ProjectProvider;
import org.jboss.forge.addon.projects.ProjectType;
import org.jboss.forge.addon.projects.ProvidedProjectFacet;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.projects.facets.PackagingFacet;
import org.jboss.forge.addon.projects.ui.NewProjectWizard;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.SingleValued;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.validate.UIValidator;
import org.jboss.forge.addon.ui.wizard.UIWizard;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.util.OperatingSystemUtils;

public class NewProjectWizardImpl
implements UIWizard,
NewProjectWizard {
    private static final Logger log = Logger.getLogger(NewProjectWizardImpl.class.getName());
    @Inject
    private ProjectFactory projectFactory;
    @Inject
    private ResourceFactory resourceFactory;
    @Inject
    private Imported<ProjectProvider> buildSystems;
    @Inject
    @WithAttributes(label="Project name", required=true)
    private UIInput<String> named;
    @Inject
    @WithAttributes(label="Top level package")
    private UIInput<String> topLevelPackage;
    @Inject
    @WithAttributes(label="Version")
    private UIInput<String> version;
    @Inject
    @WithAttributes(label="Final name")
    private UIInput<String> finalName;
    @Inject
    @WithAttributes(label="Project location")
    private UIInput<DirectoryResource> targetLocation;
    @Inject
    @WithAttributes(label="Overwrite existing project location")
    private UIInput<Boolean> overwrite;
    @Inject
    @WithAttributes(label="Project type", required=true)
    private UISelectOne<ProjectType> type;
    @Inject
    @WithAttributes(label="Build system", required=true)
    private UISelectOne<ProjectProvider> buildSystem;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(this.getClass()).name("Project: New").description("Create a new project").category(Categories.create((String[])new String[]{"Project", "Generation"}));
    }

    public boolean isEnabled(UIContext context) {
        return this.buildSystem.getValueChoices().iterator().hasNext();
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.configureProjectNamedInput();
        this.configureVersionInput();
        this.configureTargetLocationInput(builder);
        this.configureOverwriteInput();
        this.configureProjectTypeInput(builder);
        this.configureTopLevelPackageInput();
        this.configureBuildSystemInput();
        builder.add(this.named).add(this.topLevelPackage).add(this.version).add(this.finalName).add(this.targetLocation).add(this.overwrite).add(this.type).add(this.buildSystem);
    }

    private void configureProjectNamedInput() {
        this.named.addValidator(new UIValidator(){

            public void validate(UIValidationContext context) {
                if (NewProjectWizardImpl.this.named.getValue() != null && ((String)NewProjectWizardImpl.this.named.getValue()).matches(".*[^-_.a-zA-Z0-9].*")) {
                    context.addValidationError((InputComponent)NewProjectWizardImpl.this.named, "Project name must not contain spaces or special characters.");
                }
            }
        });
    }

    private void configureVersionInput() {
        this.version.setDefaultValue((Object)"1.0.0-SNAPSHOT");
    }

    private void configureTargetLocationInput(UIBuilder builder) {
        Resource resource;
        UISelection currentSelection = builder.getUIContext().getInitialSelection();
        if (!currentSelection.isEmpty() && (resource = (Resource)currentSelection.get()) instanceof DirectoryResource) {
            this.targetLocation.setDefaultValue((Object)((DirectoryResource)resource));
        }
        if (!this.targetLocation.hasDefaultValue()) {
            this.targetLocation.setDefaultValue((Object)this.resourceFactory.create(DirectoryResource.class, (Object)OperatingSystemUtils.getUserHomeDir()));
        }
    }

    private void configureOverwriteInput() {
        ((UIInput)this.overwrite.setDefaultValue((Object)false)).setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                String projectName = (String)NewProjectWizardImpl.this.named.getValue();
                return NewProjectWizardImpl.this.targetLocation.getValue() != null && projectName != null && ((DirectoryResource)NewProjectWizardImpl.this.targetLocation.getValue()).getChild(projectName).exists() && !((DirectoryResource)NewProjectWizardImpl.this.targetLocation.getValue()).getChild(projectName).listResources().isEmpty();
            }
        });
    }

    private void configureProjectTypeInput(UIBuilder builder) {
        if (builder.getUIContext().getProvider().isGUI()) {
            this.type.setItemLabelConverter((Converter)new Converter<ProjectType, String>(){

                public String convert(ProjectType source) {
                    return source == null ? null : source.getType();
                }
            });
        }
        ArrayList<ProjectType> projectTypes = new ArrayList<ProjectType>();
        for (ProjectType projectType : this.type.getValueChoices()) {
            boolean buildable = false;
            for (ProjectProvider buildSystem : this.buildSystems) {
                if (!this.isProjectTypeBuildable(projectType, buildSystem)) continue;
                projectTypes.add(projectType);
                buildable = true;
                break;
            }
            if (buildable) continue;
            log.log(Level.FINE, "ProjectType [" + projectType.getType() + "] " + "deactivated because it cannot be built with any registered ProjectProvider instances [" + this.buildSystems + "].");
        }
        Collections.sort(projectTypes, new Comparator<ProjectType>(){

            @Override
            public int compare(ProjectType left, ProjectType right) {
                return new Integer(left.priority()).compareTo(right.priority());
            }
        });
        if (!projectTypes.isEmpty()) {
            this.type.setDefaultValue(projectTypes.get(0));
        }
        this.type.setValueChoices(projectTypes);
    }

    private void configureTopLevelPackageInput() {
        this.topLevelPackage.setDefaultValue((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String result = (String)NewProjectWizardImpl.this.named.getValue();
                if (result != null) {
                    result = ("org." + result).replaceAll("\\W+", ".");
                    result = result.trim();
                    result = result.replaceAll("^\\.", "");
                    result = result.replaceAll("\\.$", "");
                } else {
                    result = "org.example";
                }
                return result;
            }
        });
    }

    private void configureBuildSystemInput() {
        this.buildSystem.setRequired(true);
        this.buildSystem.setItemLabelConverter((Converter)new Converter<ProjectProvider, String>(){

            public String convert(ProjectProvider source) {
                return source == null ? null : source.getType();
            }
        });
        this.buildSystem.setValueChoices((Callable)new Callable<Iterable<ProjectProvider>>(){

            @Override
            public Iterable<ProjectProvider> call() throws Exception {
                ArrayList<ProjectProvider> result = new ArrayList<ProjectProvider>();
                for (ProjectProvider buildSystemType : NewProjectWizardImpl.this.buildSystems) {
                    ProjectType projectType = (ProjectType)NewProjectWizardImpl.this.type.getValue();
                    if (projectType != null) {
                        if (!NewProjectWizardImpl.this.isProjectTypeBuildable(projectType, buildSystemType)) continue;
                        result.add(buildSystemType);
                        continue;
                    }
                    result.add(buildSystemType);
                }
                Collections.sort(result, new Comparator<ProjectProvider>(){

                    @Override
                    public int compare(ProjectProvider left, ProjectProvider right) {
                        return new Integer(left.priority()).compareTo(right.priority());
                    }
                });
                return result;
            }
        });
        this.buildSystem.setDefaultValue((Callable)new Callable<ProjectProvider>(){

            @Override
            public ProjectProvider call() throws Exception {
                Iterator iterator = NewProjectWizardImpl.this.buildSystem.getValueChoices().iterator();
                if (iterator.hasNext()) {
                    return (ProjectProvider)iterator.next();
                }
                return null;
            }
        });
    }

    private boolean isProjectTypeBuildable(ProjectType type, ProjectProvider buildSystem) {
        boolean result = false;
        Iterable<Class<? extends ProvidedProjectFacet>> requiredFacets = this.getRequiredBuildSystemFacets(type);
        if (requiredFacets == null || !requiredFacets.iterator().hasNext()) {
            result = true;
        } else {
            for (Class<? extends ProvidedProjectFacet> required : requiredFacets) {
                result = false;
                for (Class provided : buildSystem.getProvidedFacetTypes()) {
                    if (!provided.isAssignableFrom(required)) continue;
                    result = true;
                }
                if (result) continue;
                break;
            }
        }
        return result;
    }

    private Iterable<Class<? extends ProvidedProjectFacet>> getRequiredBuildSystemFacets(ProjectType type) {
        HashSet<Class<? extends ProvidedProjectFacet>> result = new HashSet<Class<? extends ProvidedProjectFacet>>();
        Iterable requiredFacets = type.getRequiredFacets();
        if (requiredFacets != null) {
            for (Class facetType : requiredFacets) {
                if (!ProvidedProjectFacet.class.isAssignableFrom(facetType)) continue;
                result.add(facetType);
            }
        }
        return result;
    }

    public void validate(UIValidationContext context) {
        String packg = (String)this.topLevelPackage.getValue();
        if (packg != null && !packg.matches("(?i)(~\\.)?([a-z0-9_]+\\.?)+[a-z0-9_]")) {
            context.addValidationError(this.topLevelPackage, "Top level package must be a valid package name.");
        }
        if (this.overwrite.isEnabled() && !((Boolean)this.overwrite.getValue()).booleanValue()) {
            String errorMessage = String.format("Project location '%s' is not empty.", ((DirectoryResource)this.targetLocation.getValue()).getChild((String)this.named.getValue()));
            context.addValidationError(this.targetLocation, errorMessage);
        }
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Result result = Results.success((String)("Project named '" + (String)this.named.getValue() + "' has been created."));
        DirectoryResource directory = (DirectoryResource)this.targetLocation.getValue();
        DirectoryResource targetDir = directory.getChildDirectory((String)this.named.getValue());
        if (targetDir.mkdirs() || ((Boolean)this.overwrite.getValue()).booleanValue()) {
            ProjectType value = (ProjectType)this.type.getValue();
            Project project = null;
            project = value != null ? this.projectFactory.createProject((Resource)targetDir, (ProjectProvider)this.buildSystem.getValue(), value.getRequiredFacets()) : this.projectFactory.createProject((Resource)targetDir, (ProjectProvider)this.buildSystem.getValue());
            if (project != null) {
                UIContext uiContext = context.getUIContext();
                MetadataFacet metadataFacet = (MetadataFacet)project.getFacet(MetadataFacet.class);
                metadataFacet.setProjectName((String)this.named.getValue());
                metadataFacet.setProjectVersion((String)this.version.getValue());
                metadataFacet.setProjectGroupName((String)this.topLevelPackage.getValue());
                PackagingFacet packagingFacet = (PackagingFacet)project.getFacet(PackagingFacet.class);
                if (this.finalName.hasValue()) {
                    packagingFacet.setFinalName((String)this.finalName.getValue());
                } else {
                    packagingFacet.setFinalName((String)this.named.getValue());
                }
                uiContext.setSelection((Object)project.getRoot());
                uiContext.getAttributeMap().put(Project.class, project);
            } else {
                result = Results.fail((String)("Could not create project of type: [" + value + "]"));
            }
        } else {
            result = Results.fail((String)("Could not create target location: " + targetDir));
        }
        return result;
    }

    public UIInput<String> getNamed() {
        return this.named;
    }

    public UIInput<DirectoryResource> getTargetLocation() {
        return this.targetLocation;
    }

    public UIInput<Boolean> getOverwrite() {
        return this.overwrite;
    }

    public UISelectOne<ProjectType> getType() {
        return this.type;
    }

    public SingleValued<UIInput<String>, String> getTopLevelPackage() {
        return this.topLevelPackage;
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        if (this.type.getValue() != null) {
            return Results.navigateTo((Class)((ProjectType)this.type.getValue()).getSetupFlow());
        }
        return null;
    }
}

