/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.result.navigation;

import java.util.LinkedList;
import javax.enterprise.inject.Vetoed;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;

@Vetoed
class CompositeCommand
implements UICommand {
    private final UICommandMetadata metadata;
    private final Iterable<UICommand> commands;

    public CompositeCommand(UICommandMetadata metadata, Iterable<UICommand> commands) {
        this.metadata = metadata;
        this.commands = commands;
    }

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return this.metadata;
    }

    @Override
    public boolean isEnabled(UIContext context) {
        return true;
    }

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
        for (UICommand command : this.commands) {
            command.initializeUI(builder);
        }
    }

    @Override
    public void validate(UIValidationContext context) {
        for (UICommand command : this.commands) {
            command.validate(context);
        }
    }

    @Override
    public Result execute(UIExecutionContext context) throws Exception {
        LinkedList<Result> results = new LinkedList<Result>();
        for (UICommand command : this.commands) {
            Result result = command.execute(context);
            results.add(result);
        }
        return Results.aggregate(results);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.commands == null ? 0 : this.commands.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeCommand other = (CompositeCommand)obj;
        if (this.commands == null ? other.commands != null : !this.commands.equals(other.commands)) {
            return false;
        }
        return !(this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata));
    }
}

