/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.resource.monitor;

import java.io.File;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.ResourceFilter;
import org.jboss.forge.addon.resource.events.ResourceCreated;
import org.jboss.forge.addon.resource.events.ResourceDeleted;
import org.jboss.forge.addon.resource.events.ResourceEvent;
import org.jboss.forge.addon.resource.events.ResourceModified;
import org.jboss.forge.addon.resource.monitor.FileMonitor;
import org.jboss.forge.addon.resource.monitor.ResourceListener;
import org.jboss.forge.addon.resource.monitor.ResourceMonitor;
import org.jboss.forge.furnace.spi.ListenerRegistration;

public class ResourceMonitorImpl
implements ResourceMonitor {
    private static final Logger log = Logger.getLogger(ResourceMonitorImpl.class.getName());
    private final FileMonitor fileMonitor;
    private final DirectoryResource resource;
    private final Set<ResourceListener> listeners = new LinkedHashSet<ResourceListener>();
    private final ResourceFactory resourceFactory;
    private final ResourceFilter resourceFilter;

    public ResourceMonitorImpl(FileMonitor fileMonitor, DirectoryResource resource, ResourceFactory resourceFactory, ResourceFilter resourceFilter) {
        this.fileMonitor = fileMonitor;
        this.resource = resource;
        this.resourceFactory = resourceFactory;
        this.resourceFilter = resourceFilter;
    }

    public ListenerRegistration<ResourceListener> addResourceListener(final ResourceListener listener) {
        this.listeners.add(listener);
        return new ListenerRegistration<ResourceListener>(){

            public ResourceListener removeListener() {
                ResourceMonitorImpl.this.listeners.remove(listener);
                return listener;
            }
        };
    }

    void onPathModify(Path path) {
        FileResource fileResource = (FileResource)this.resourceFactory.create(FileResource.class, (Object)path.toFile());
        this.fireEvent((ResourceEvent)new ResourceModified((Resource)fileResource));
    }

    void onPathCreate(Path path) {
        FileResource fileResource = (FileResource)this.resourceFactory.create(FileResource.class, (Object)path.toFile());
        this.fireEvent((ResourceEvent)new ResourceCreated((Resource)fileResource));
    }

    void onPathDelete(Path path) {
        FileResource fileResource = (FileResource)this.resourceFactory.create(FileResource.class, (Object)path.toFile());
        this.fireEvent((ResourceEvent)new ResourceDeleted((Resource)fileResource));
    }

    private void fireEvent(ResourceEvent event) {
        if (this.resourceFilter == null || this.resourceFilter.accept((Object)event.getResource())) {
            for (ResourceListener listener : this.listeners) {
                try {
                    listener.processEvent(event);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error while firing listener", e);
                }
            }
        }
    }

    public DirectoryResource getResource() {
        return this.resource;
    }

    Path getResourcePath() {
        return ((File)this.resource.getUnderlyingResourceObject()).toPath();
    }

    public void cancel() {
        this.fileMonitor.cancel(this);
        this.listeners.clear();
    }
}

