/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.template.SimpleScalar;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.pegdown.WindupCodeBlockPlugin;
import org.pegdown.LinkRenderer;
import org.pegdown.PegDownProcessor;
import org.pegdown.ToHtmlSerializer;
import org.pegdown.ast.RootNode;
import org.pegdown.plugins.PegDownPlugins;

public class MarkdownToHtmlMethod
implements WindupFreeMarkerMethod {
    public Object exec(List arguments) throws TemplateModelException {
        if (arguments.size() != 1) {
            throw new TemplateModelException("Error, method expects one argument (String)");
        }
        SimpleScalar freemarkerArg = (SimpleScalar)arguments.get(0);
        String markdownSource = freemarkerArg.getAsString();
        PegDownPlugins plugins = PegDownPlugins.builder().withPlugin(WindupCodeBlockPlugin.class, new Object[0]).build();
        PegDownProcessor proc = new PegDownProcessor(0, plugins);
        RootNode outputNode = proc.parseMarkdown(markdownSource.toCharArray());
        ArrayList<WindupCodeBlockPlugin> serializerPlugins = new ArrayList<WindupCodeBlockPlugin>(1);
        serializerPlugins.add(new WindupCodeBlockPlugin());
        ToHtmlSerializer serializer = new ToHtmlSerializer(new LinkRenderer(), Collections.emptyMap(), serializerPlugins);
        return serializer.toHtml(outputNode);
    }

    public String getMethodName() {
        return "markdownToHtml";
    }

    public String getDescription() {
        return "Converts from an input string in Markdown format to an output string in HTML format";
    }

    public void setContext(GraphRewrite event) {
    }
}

