/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.ruleexecution;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.wrappers.event.listener.GraphChangedListener;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RuleLifecycleListener;
import org.jboss.windup.config.RuleProvider;
import org.jboss.windup.config.metadata.RuleProviderRegistry;
import org.jboss.windup.reporting.ruleexecution.RuleExecutionInformation;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class RuleExecutionResultsListener
implements RuleLifecycleListener {
    private IdentityHashMap<Rule, RuleExecutionInformation> ruleExecutionInformation = new IdentityHashMap();
    private GraphRewrite event;
    private Rule currentRule = null;

    public static RuleExecutionResultsListener instance(GraphRewrite event) {
        return (RuleExecutionResultsListener)event.getRewriteContext().get(RuleExecutionResultsListener.class);
    }

    public List<RuleExecutionInformation> getRuleExecutionInformation(AbstractRuleProvider provider) {
        RuleProviderRegistry ruleExecutionMetadata = RuleProviderRegistry.instance((GraphRewrite)this.event);
        List rules = ruleExecutionMetadata.getRules((RuleProvider)provider);
        ArrayList<RuleExecutionInformation> allRuleExecutions = new ArrayList<RuleExecutionInformation>();
        for (Rule rule : rules) {
            allRuleExecutions.add(this.ruleExecutionInformation.get(rule));
        }
        return allRuleExecutions;
    }

    public void beforeExecution(GraphRewrite event) {
        this.ruleExecutionInformation.clear();
        this.event = event;
        event.getRewriteContext().put(RuleExecutionResultsListener.class, (Object)this);
        event.getGraphContext().getGraph().addListener((GraphChangedListener)new GraphChangeListener());
    }

    public void beforeRuleEvaluation(GraphRewrite event, Rule rule, EvaluationContext context) {
        this.ruleExecutionInformation.put(rule, new RuleExecutionInformation(rule));
        this.currentRule = rule;
    }

    public void afterRuleConditionEvaluation(GraphRewrite event, EvaluationContext context, Rule rule, boolean result) {
        this.ruleExecutionInformation.get(rule).setEvaluationResult(result);
        if (!result) {
            this.currentRule = null;
        }
    }

    public void beforeRuleOperationsPerformed(GraphRewrite event, EvaluationContext context, Rule rule) {
    }

    public void afterRuleOperationsPerformed(GraphRewrite event, EvaluationContext context, Rule rule) {
        this.ruleExecutionInformation.get(rule).setExecuted(true);
        this.currentRule = null;
    }

    public void afterRuleExecutionFailed(GraphRewrite event, EvaluationContext context, Rule rule, Throwable failureCause) {
        this.ruleExecutionInformation.get(rule).setFailed(true);
        this.ruleExecutionInformation.get(rule).setFailureCause(failureCause);
        this.currentRule = null;
    }

    public void afterExecution(GraphRewrite event) {
    }

    private class GraphChangeListener
    implements GraphChangedListener {
        private GraphChangeListener() {
        }

        public synchronized void vertexAdded(Vertex vertex) {
            if (RuleExecutionResultsListener.this.currentRule != null) {
                ((RuleExecutionInformation)RuleExecutionResultsListener.this.ruleExecutionInformation.get(RuleExecutionResultsListener.this.currentRule)).addVertexIDAdded(vertex.getId());
            }
        }

        public synchronized void vertexRemoved(Vertex vertex, Map<String, Object> props) {
            if (RuleExecutionResultsListener.this.currentRule != null) {
                ((RuleExecutionInformation)RuleExecutionResultsListener.this.ruleExecutionInformation.get(RuleExecutionResultsListener.this.currentRule)).addVertexIDRemoved(vertex.getId());
            }
        }

        public synchronized void edgeAdded(Edge edge) {
            if (RuleExecutionResultsListener.this.currentRule != null) {
                ((RuleExecutionInformation)RuleExecutionResultsListener.this.ruleExecutionInformation.get(RuleExecutionResultsListener.this.currentRule)).addEdgeIDAdded(edge.getId());
            }
        }

        public synchronized void edgeRemoved(Edge edge, Map<String, Object> props) {
            if (RuleExecutionResultsListener.this.currentRule != null) {
                ((RuleExecutionInformation)RuleExecutionResultsListener.this.ruleExecutionInformation.get(RuleExecutionResultsListener.this.currentRule)).addVertexIDRemoved(edge.getId());
            }
        }

        public void edgePropertyRemoved(Edge edge, String key, Object removedValue) {
        }

        public void vertexPropertyChanged(Vertex vertex, String key, Object oldValue, Object setValue) {
        }

        public void vertexPropertyRemoved(Vertex vertex, String key, Object removedValue) {
        }

        public void edgePropertyChanged(Edge edge, String key, Object oldValue, Object setValue) {
        }
    }
}

