/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.xml;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.reporting.config.Link;
import org.jboss.windup.reporting.config.classification.Classification;
import org.jboss.windup.reporting.model.Severity;
import org.jboss.windup.util.exception.WindupException;
import org.joox.JOOX;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="classification", namespace="http://windup.jboss.org/v1/xml")
public class ClassificationHandler
implements ElementHandler<Classification> {
    public Classification processElement(ParserContext handlerManager, Element element) throws ConfigurationException {
        String classificationStr = JOOX.$((Element)element).attr("classification");
        if (StringUtils.isBlank((String)classificationStr)) {
            throw new WindupException("Error, 'classification' element must have a non-empty 'classification' attribute (eg, 'Mule ESB Transformer')");
        }
        String description = JOOX.$((Element)element).attr("description");
        String of = JOOX.$((Element)element).attr("of");
        String effortStr = JOOX.$((Element)element).attr("effort");
        String severityStr = JOOX.$((Element)element).attr("severity");
        Classification classification = (Classification)Classification.as((String)classificationStr);
        if (of != null) {
            classification.setVariableName(of);
        }
        if (StringUtils.isNotBlank((String)effortStr)) {
            try {
                int effort = Integer.parseInt(effortStr);
                classification.withEffort(effort);
            }
            catch (NumberFormatException e) {
                throw new WindupException("Could not parse effort level: " + effortStr + " as an integer!");
            }
        }
        if (StringUtils.isNotBlank((String)severityStr)) {
            Severity severity = Severity.valueOf((String)severityStr);
            classification.withSeverity(severity);
        }
        if (StringUtils.isNotBlank((String)description)) {
            classification.withDescription(description);
        }
        List children = JOOX.$((Element)element).children("link").get();
        for (Element child : children) {
            Link link = (Link)handlerManager.processElement(child);
            classification.with(link);
        }
        return classification;
    }
}

