/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console;

import org.jboss.aesh.console.ConsoleCallback;
import org.jboss.aesh.console.ConsoleOperation;
import org.jboss.aesh.console.Process;
import org.jboss.aesh.console.ProcessManager;
import org.jboss.aesh.console.command.CommandOperation;
import org.jboss.aesh.console.command.CommandResult;

public class AeshProcess
implements Runnable,
Process {
    private ProcessManager manager;
    private final ConsoleCallback consoleCallback;
    private final ConsoleOperation operation;
    private CommandResult exitResult;
    private Thread myThread;
    private Process.Status status;

    public AeshProcess(int pid, ProcessManager manager, ConsoleCallback consoleCallback, ConsoleOperation consoleOperation) {
        this.manager = manager;
        this.consoleCallback = consoleCallback;
        this.operation = consoleOperation;
        this.consoleCallback.setProcess(this);
        this.operation.setPid(pid);
        this.status = Process.Status.FOREGROUND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Thread.currentThread().setName("AeshProcess: " + this.operation.getPid());
            this.myThread = Thread.currentThread();
            this.setExitResult(this.consoleCallback.execute(this.operation));
        }
        catch (InterruptedException e) {
            this.setExitResult(-1);
        }
        finally {
            this.manager.processHaveFinished(this);
        }
    }

    @Override
    public void setManager(ProcessManager manager) {
        this.manager = manager;
    }

    @Override
    public CommandOperation getInput() throws InterruptedException {
        return this.manager.getInput(this.getPID());
    }

    @Override
    public int getPID() {
        return this.operation.getPid();
    }

    private void setExitResult(int exitStatus) {
        if (exitStatus == 0) {
            this.exitResult = CommandResult.SUCCESS;
            this.exitResult.setResultValue(0);
        } else {
            this.exitResult = CommandResult.FAILURE;
            this.exitResult.setResultValue(exitStatus);
        }
    }

    @Override
    public CommandResult getExitResult() {
        return this.exitResult;
    }

    @Override
    public void interrupt() {
        if (this.myThread != null) {
            this.myThread.interrupt();
        }
    }

    @Override
    public Process.Status getStatus() {
        return this.status;
    }

    @Override
    public void updateStatus(Process.Status status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AeshProcess)) {
            return false;
        }
        AeshProcess that = (AeshProcess)o;
        return this.operation.getPid() == that.operation.getPid();
    }

    public int hashCode() {
        return this.operation.getPid();
    }

    public String toString() {
        return "AeshProcess{pid=" + this.operation.getPid() + ", manager=" + this.manager + ", consoleCallback=" + this.consoleCallback + ", operation=" + this.operation + '}';
    }
}

