/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.less.aesh;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Scanner;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.console.man.AeshFileDisplayer;
import org.jboss.aesh.console.man.FileParser;
import org.jboss.aesh.console.man.TerminalPage;
import org.jboss.aesh.extensions.page.SimpleFileParser;
import org.jboss.aesh.extensions.text.highlight.Encoder;
import org.jboss.aesh.extensions.text.highlight.Scanner;
import org.jboss.aesh.extensions.text.highlight.Syntax;
import org.jboss.aesh.io.Resource;
import org.jboss.aesh.util.ANSI;

@CommandDefinition(name="less", description="less is more")
public class Less
extends AeshFileDisplayer {
    @Arguments
    List<Resource> arguments;
    @Option(hasValue=false)
    private boolean color;
    private SimpleFileParser loader;

    public void setFile(File file) throws IOException {
        this.loader.setFile(file);
    }

    public void setFile(String filename) throws IOException {
        this.loader.setFile(filename);
    }

    public void setInput(String input) throws IOException {
        this.loader.readPageAsString(input);
    }

    public void setFile(InputStream inputStream, String fileName) {
        this.loader.setFile(inputStream, fileName);
    }

    public FileParser getFileParser() {
        return this.loader;
    }

    public void displayBottom() throws IOException {
        if (this.getSearchStatus() == TerminalPage.Search.SEARCHING) {
            this.clearBottomLine();
            this.writeToConsole("/" + this.getSearchWord());
        } else if (this.getSearchStatus() == TerminalPage.Search.NOT_FOUND) {
            this.clearBottomLine();
            this.writeToConsole(ANSI.getInvertedBackground() + "Pattern not found (press RETURN)" + ANSI.defaultText());
        } else if (this.getSearchStatus() == TerminalPage.Search.RESULT) {
            this.writeToConsole(":");
        } else if (this.getSearchStatus() == TerminalPage.Search.NO_SEARCH) {
            if (this.isAtBottom()) {
                this.writeToConsole(ANSI.getInvertedBackground() + "(END)" + ANSI.defaultText());
            } else {
                this.writeToConsole(":");
            }
        }
    }

    public CommandResult execute(CommandInvocation commandInvocation) throws IOException, InterruptedException {
        this.setCommandInvocation(commandInvocation);
        this.loader = new SimpleFileParser();
        if (commandInvocation.getShell().in().getStdIn().available() > 0) {
            Scanner s = new Scanner(commandInvocation.getShell().in().getStdIn()).useDelimiter("\\A");
            String fileContent = s.hasNext() ? s.next() : "";
            this.setInput(fileContent);
            this.afterAttach();
        } else if (this.arguments != null && this.arguments.size() > 0) {
            Resource f = (Resource)this.arguments.get(0).resolve(commandInvocation.getAeshContext().getCurrentWorkingDirectory()).get(0);
            if (f.isLeaf()) {
                if (this.color) {
                    String content = this.readFile(f.read());
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Syntax.builtIns();
                    Syntax.Builder.create().encoderType(Encoder.Type.TERMINAL).output(baos).scanner(Scanner.Factory.byFileName(f.getName())).execute(content);
                    this.setInput(new String(baos.toByteArray()));
                    this.afterAttach();
                } else {
                    this.setFile(f.read(), f.getName());
                    this.afterAttach();
                }
            } else if (f.isDirectory()) {
                this.getShell().err().println(f.getAbsolutePath() + ": is a directory");
            } else {
                this.getShell().err().println(f.getAbsolutePath() + ": No such file or directory");
            }
        }
        return CommandResult.SUCCESS;
    }

    private String readFile(InputStream inputStream) throws IOException {
        String line;
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        while ((line = reader.readLine()) != null) {
            builder.append(line).append(Config.getLineSeparator());
        }
        inputStream.close();
        return builder.toString();
    }
}

