/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.frames;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.util.ElementHelper;
import com.tinkerpop.frames.EdgeFrame;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.UnhandledMethodException;
import com.tinkerpop.frames.VertexFrame;
import com.tinkerpop.frames.annotations.AnnotationHandler;
import com.tinkerpop.frames.modules.MethodHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;

public class FramedElement
implements InvocationHandler {
    private final Direction direction;
    protected final FramedGraph framedGraph;
    protected final Element element;
    private static Method hashCodeMethod;
    private static Method equalsMethod;
    private static Method toStringMethod;
    private static Method asVertexMethod;
    private static Method asEdgeMethod;

    public FramedElement(FramedGraph framedGraph, Element element, Direction direction) {
        if (null == framedGraph) {
            throw new IllegalArgumentException("FramedGraph can not be null");
        }
        if (null == element) {
            throw new IllegalArgumentException("Element can not be null");
        }
        this.element = element;
        this.framedGraph = framedGraph;
        this.direction = direction;
    }

    public FramedElement(FramedGraph framedGraph, Element element) {
        this(framedGraph, element, Direction.OUT);
    }

    @Override
    public Object invoke(Object proxy, Method originalMethod, Object[] arguments) {
        Method method = null;
        Class<?> methodInterface = null;
        block0: for (Class<?> c : proxy.getClass().getInterfaces()) {
            if (method != null && c.isAssignableFrom(methodInterface)) continue;
            for (Method interfaceMethod : c.getMethods()) {
                if (!this.compareMethods(originalMethod, interfaceMethod)) continue;
                if (interfaceMethod.getAnnotations().length <= 0) continue block0;
                method = interfaceMethod;
                methodInterface = c;
                continue block0;
            }
        }
        if (method == null) {
            method = originalMethod;
        }
        Annotation[] annotations = method.getAnnotations();
        Map<Class<Annotation>, AnnotationHandler<?>> annotationHandlers = this.framedGraph.getConfig().getAnnotationHandlers();
        Map<Class<Annotation>, MethodHandler<?>> methodHandlers = this.framedGraph.getConfig().getMethodHandlers();
        for (Annotation annotation : annotations) {
            MethodHandler<?> methodHandler = methodHandlers.get(annotation.annotationType());
            if (methodHandler == null) continue;
            return methodHandler.processElement(proxy, method, arguments, annotation, this.framedGraph, this.element);
        }
        for (Annotation annotation : annotations) {
            AnnotationHandler<?> annotationHandler = annotationHandlers.get(annotation.annotationType());
            if (annotationHandler == null) continue;
            return annotationHandler.processElement(annotation, method, arguments, this.framedGraph, this.element, this.direction);
        }
        if (originalMethod.equals(hashCodeMethod)) {
            return this.element.hashCode();
        }
        if (originalMethod.equals(equalsMethod)) {
            return this.proxyEquals(arguments[0]);
        }
        if (originalMethod.equals(toStringMethod)) {
            return this.element.toString();
        }
        if (originalMethod.equals(asVertexMethod) || originalMethod.equals(asEdgeMethod)) {
            return this.element;
        }
        if (method.getAnnotations().length == 0) {
            throw new UnhandledMethodException("The method " + method.getDeclaringClass().getName() + "." + method.getName() + " has no annotations, therefore frames cannot handle the method.");
        }
        throw new UnhandledMethodException("The method " + method.getDeclaringClass().getName() + "." + method.getName() + " was not annotated with any annotations that the framed graph is configured for. Please check your frame interface and/or graph configuration.");
    }

    private boolean compareMethods(Method m1, Method m2) {
        Class<?>[] params2;
        if (!m1.getName().equals(m2.getName())) {
            return false;
        }
        if (!m1.getReturnType().equals(m2.getReturnType())) {
            return false;
        }
        Class<?>[] params1 = m1.getParameterTypes();
        if (params1.length == (params2 = m2.getParameterTypes()).length) {
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i] == params2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Boolean proxyEquals(Object other) {
        if (other instanceof VertexFrame) {
            return this.element.equals(((VertexFrame)other).asVertex());
        }
        if (other instanceof EdgeFrame) {
            return this.element.equals(((EdgeFrame)other).asEdge());
        }
        if (other instanceof Element) {
            return ElementHelper.areEqual((Element)this.element, (Object)other);
        }
        return Boolean.FALSE;
    }

    public Element getElement() {
        return this.element;
    }

    static {
        try {
            hashCodeMethod = Object.class.getMethod("hashCode", new Class[0]);
            equalsMethod = Object.class.getMethod("equals", Object.class);
            toStringMethod = Object.class.getMethod("toString", new Class[0]);
            asVertexMethod = VertexFrame.class.getMethod("asVertex", new Class[0]);
            asEdgeMethod = EdgeFrame.class.getMethod("asEdge", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }
}

