/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.core.schema.VertexLabelMaker;
import com.thinkaurelius.titan.graphdb.internal.TitanSchemaCategory;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.StandardRelationTypeMaker;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionCategory;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionMap;
import com.thinkaurelius.titan.graphdb.types.VertexLabelVertex;
import org.apache.commons.lang.StringUtils;

public class StandardVertexLabelMaker
implements VertexLabelMaker {
    private final StandardTitanTx tx;
    private String name;
    private boolean partitioned;
    private boolean isStatic;

    public StandardVertexLabelMaker(StandardTitanTx tx) {
        this.tx = tx;
    }

    public static void checkName(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"Need to specify name");
        for (char c : StandardRelationTypeMaker.RESERVED_CHARS) {
            Preconditions.checkArgument((name.indexOf(c) < 0 ? 1 : 0) != 0, (String)"Name contains reserved character %s: %s", (Object[])new Object[]{Character.valueOf(c), name});
        }
    }

    public StandardVertexLabelMaker name(String name) {
        StandardVertexLabelMaker.checkName(name);
        this.name = name;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public StandardVertexLabelMaker partition() {
        this.partitioned = true;
        return this;
    }

    @Override
    public StandardVertexLabelMaker setStatic() {
        this.isStatic = true;
        return this;
    }

    @Override
    public VertexLabel make() {
        Preconditions.checkArgument((!this.partitioned || !this.isStatic ? 1 : 0) != 0, (Object)"A vertex label cannot be partitioned and static at the same time");
        TypeDefinitionMap def = new TypeDefinitionMap();
        def.setValue(TypeDefinitionCategory.PARTITIONED, this.partitioned);
        def.setValue(TypeDefinitionCategory.STATIC, this.isStatic);
        return (VertexLabelVertex)this.tx.makeSchemaVertex(TitanSchemaCategory.VERTEXLABEL, this.name, def);
    }
}

