/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import org.jboss.windup.ast.java.JavaASTProcessor;
import org.jboss.windup.ast.java.WildcardImportResolver;
import org.jboss.windup.ast.java.data.JavaClassReference;
import org.jboss.windup.ast.java.data.JavaClassReferences;
import org.jboss.windup.ast.java.data.TypeReferenceLocation;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.Commit;
import org.jboss.windup.config.operation.IterationProgress;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.model.JarArchiveModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.rules.apps.java.scan.ast.JavaAnnotationTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.JavaTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.TypeInterestFactory;
import org.jboss.windup.rules.apps.java.scan.ast.WindupWildcardImportResolver;
import org.jboss.windup.rules.apps.java.service.TypeReferenceService;
import org.jboss.windup.rules.apps.java.service.WindupJavaConfigurationService;
import org.jboss.windup.util.ExecutionStatistics;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class AnalyzeJavaFilesRuleProvider
extends AbstractRuleProvider {
    public AnalyzeJavaFilesRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(AnalyzeJavaFilesRuleProvider.class).setPhase(InitialAnalysisPhase.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(JavaSourceFileModel.class)).perform((Operation)new ParseSourceOperation().and((Operation)IterationProgress.monitoring((String)"Analyzed Java File: ", (int)250)).and((Operation)Commit.every((int)10)));
    }

    private final class ParseSourceOperation
    extends AbstractIterationOperation<JavaSourceFileModel> {
        private ParseSourceOperation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(GraphRewrite event, EvaluationContext context, JavaSourceFileModel payload) {
            ExecutionStatistics.get().begin("AnalyzeJavaFilesRuleProvider.analyzeFile");
            try {
                WindupJavaConfigurationService windupJavaConfigurationService = new WindupJavaConfigurationService(event.getGraphContext());
                if (!windupJavaConfigurationService.shouldScanPackage(payload.getPackageName())) {
                    return;
                }
                GraphService service = new GraphService(event.getGraphContext(), JavaSourceFileModel.class);
                Iterable findAll = service.findAll();
                HashSet<String> javaFilePaths = new HashSet<String>();
                for (JavaSourceFileModel javaFile : findAll) {
                    FileModel rootSourceFolder = javaFile.getRootSourceFolder();
                    if (rootSourceFolder == null) continue;
                    javaFilePaths.add(rootSourceFolder.getFilePath());
                }
                GraphService libraryService = new GraphService(event.getGraphContext(), JarArchiveModel.class);
                Iterable libraries = libraryService.findAll();
                HashSet<String> librariesPaths = new HashSet<String>();
                for (JarArchiveModel library : libraries) {
                    if (library.getUnzippedDirectory() != null) {
                        librariesPaths.add(library.getUnzippedDirectory().getFilePath());
                        continue;
                    }
                    librariesPaths.add(library.getFilePath());
                }
                File sourceFile = payload.asFile();
                ExecutionStatistics.get().begin("AnalyzeJavaFilesRuleProvider.parseFile");
                WindupWildcardImportResolver importResolver = new WindupWildcardImportResolver();
                WindupWildcardImportResolver.setGraphContext(event.getGraphContext());
                try {
                    JavaClassReferences references = JavaASTProcessor.analyzeJavaFile((WildcardImportResolver)importResolver, librariesPaths, javaFilePaths, (Path)sourceFile.toPath());
                    TypeReferenceService typeReferenceService = new TypeReferenceService(event.getGraphContext());
                    for (JavaClassReference reference : references.getReferences()) {
                        if (reference.getLocation() != TypeReferenceLocation.TYPE && !TypeInterestFactory.matchesAny(reference.getQualifiedName(), reference.getLocation())) continue;
                        JavaTypeReferenceModel typeReference = typeReferenceService.createTypeReference(payload, reference.getLocation(), reference.getLineNumber(), reference.getColumn(), reference.getLength(), reference.getQualifiedName(), reference.getLine());
                        if (reference.getLocation() != TypeReferenceLocation.ANNOTATION) continue;
                        this.addAnnotationValues(event.getGraphContext(), typeReference, reference.getAnnotationValues());
                    }
                    ExecutionStatistics.get().end("AnalyzeJavaFilesRuleProvider.parseFile");
                }
                finally {
                    WindupWildcardImportResolver.setGraphContext(null);
                }
            }
            finally {
                ExecutionStatistics.get().end("AnalyzeJavaFilesRuleProvider.analyzeFile");
            }
        }

        private void addAnnotationValues(GraphContext context, JavaTypeReferenceModel typeReference, Map<String, String> annotationValues) {
            GraphService annotationTypeReferenceService = new GraphService(context, JavaAnnotationTypeReferenceModel.class);
            JavaAnnotationTypeReferenceModel javaAnnotationTypeReferenceModel = (JavaAnnotationTypeReferenceModel)annotationTypeReferenceService.addTypeToModel((WindupVertexFrame)typeReference);
            javaAnnotationTypeReferenceModel.setAnnotationValues(annotationValues);
        }

        public String toString() {
            return "ParseJavaSource";
        }
    }
}

