/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec;

import java.io.File;
import java.nio.file.Path;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.windup.config.DefaultEvaluationContext;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.PreRulesetEvaluation;
import org.jboss.windup.config.RuleLifecycleListener;
import org.jboss.windup.config.RuleSubset;
import org.jboss.windup.config.loader.RuleLoader;
import org.jboss.windup.config.metadata.RuleProviderRegistry;
import org.jboss.windup.exec.DefaultRuleLifecycleListener;
import org.jboss.windup.exec.WindupProcessor;
import org.jboss.windup.exec.configuration.WindupConfiguration;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.util.Checks;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.config.RuleVisit;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.DefaultParameterValueStore;
import org.ocpsoft.rewrite.param.ParameterValueStore;
import org.ocpsoft.rewrite.util.Visitor;

public class WindupProcessorImpl
implements WindupProcessor {
    private static Logger LOG = Logging.get(WindupProcessorImpl.class);
    @Inject
    private RuleLoader ruleLoader;
    @Inject
    private Imported<RuleLifecycleListener> listeners;

    public void execute() {
        this.execute(new WindupConfiguration());
    }

    public void execute(WindupConfiguration windupConfiguration) {
        long startTime = System.currentTimeMillis();
        this.validateConfig(windupConfiguration);
        GraphContext context = windupConfiguration.getGraphContext();
        context.setOptions(windupConfiguration.getOptionMap());
        WindupConfigurationModel configModel = WindupConfigurationService.getConfigurationModel((GraphContext)context);
        configModel.setInputPath(this.getFileModel(context, windupConfiguration.getInputPath()));
        configModel.setOutputPath(this.getFileModel(context, windupConfiguration.getOutputDirectory()));
        configModel.setOfflineMode(windupConfiguration.isOffline());
        for (Path path : windupConfiguration.getAllUserRulesDirectories()) {
            System.out.println("Using user rules dir: " + path);
            if (path == null) {
                throw new WindupException("Null path found (all paths are: " + windupConfiguration.getAllUserRulesDirectories() + ")");
            }
            configModel.addUserRulesPath(this.getFileModel(context, path));
        }
        for (Path path : windupConfiguration.getAllIgnoreDirectories()) {
            configModel.addUserIgnorePath(this.getFileModel(context, path));
        }
        final GraphRewrite event = new GraphRewrite(context);
        RuleProviderRegistry providerRegistry = this.ruleLoader.loadConfiguration(context, windupConfiguration.getRuleProviderFilter());
        event.getRewriteContext().put(RuleProviderRegistry.class, (Object)providerRegistry);
        Configuration rules = providerRegistry.getConfiguration();
        RuleSubset ruleSubset = RuleSubset.create((Configuration)rules);
        if (windupConfiguration.getProgressMonitor() != null) {
            ruleSubset.addLifecycleListener((RuleLifecycleListener)new DefaultRuleLifecycleListener(windupConfiguration.getProgressMonitor(), rules));
        }
        for (RuleLifecycleListener listener : this.listeners) {
            ruleSubset.addLifecycleListener(listener);
        }
        new RuleVisit((Rule)ruleSubset).accept((Visitor)new Visitor<Rule>(){

            public void visit(Rule r) {
                if (r instanceof PreRulesetEvaluation) {
                    ((PreRulesetEvaluation)r).preRulesetEvaluation(event);
                }
            }
        });
        ruleSubset.perform((Rewrite)event, this.createEvaluationContext());
        long endTime = System.currentTimeMillis();
        long seconds = (endTime - startTime) / 1000L;
        LOG.info("Windup execution took " + seconds + " seconds to execute on input: " + windupConfiguration.getInputPath() + "!");
        ExecutionStatistics.get().reset();
    }

    private FileModel getFileModel(GraphContext context, Path path) {
        return new FileService(context).createByFilePath(path.toString());
    }

    private EvaluationContext createEvaluationContext() {
        DefaultEvaluationContext evaluationContext = new DefaultEvaluationContext();
        DefaultParameterValueStore values = new DefaultParameterValueStore();
        evaluationContext.put(ParameterValueStore.class, (Object)values);
        return evaluationContext;
    }

    private void validateConfig(WindupConfiguration windupConfiguration) {
        Assert.notNull((Object)windupConfiguration, (String)"Windup configuration must not be null. (Call default execution if no configuration is required.)");
        GraphContext context = windupConfiguration.getGraphContext();
        Assert.notNull((Object)context, (String)"Windup GraphContext must not be null!");
        Path inputPath = windupConfiguration.getInputPath();
        Assert.notNull((Object)inputPath, (String)"Path to the application must not be null!");
        Checks.checkFileOrDirectoryToBeRead((File)inputPath.toFile(), (String)"Application");
        Path outputDirectory = windupConfiguration.getOutputDirectory();
        Assert.notNull((Object)outputDirectory, (String)"Output directory must not be null!");
        Checks.checkDirectoryToBeFilled((File)outputDirectory.toFile(), (String)"Output directory");
    }
}

