/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.impl.addons.AddonRepositoryImpl;
import org.jboss.forge.furnace.impl.graph.AddonDependencyEdge;
import org.jboss.forge.furnace.impl.graph.AddonGraph;
import org.jboss.forge.furnace.impl.graph.AddonVertex;
import org.jboss.forge.furnace.repositories.AddonDependencyEntry;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.versions.EmptyVersion;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.graph.SimpleDirectedGraph;

public class CompleteAddonGraph
extends AddonGraph<CompleteAddonGraph> {
    private Logger logger = Logger.getLogger(CompleteAddonGraph.class.getName());
    DirectedGraph<AddonVertex, AddonDependencyEdge> graph = new SimpleDirectedGraph(AddonDependencyEdge.class);

    public CompleteAddonGraph(Collection<AddonRepository> repositories) {
        Set<AddonId> enabled = this.getAllEnabledAddonsInAllRepositories(repositories);
        LinkedHashMap<AddonId, Set> dependencyMap = new LinkedHashMap<AddonId, Set>();
        for (AddonId addonId : enabled) {
            for (AddonRepository repository : repositories) {
                if (!repository.isEnabled(addonId)) continue;
                Set dependencies = repository.getAddonDependencies(addonId);
                dependencyMap.put(addonId, dependencies);
            }
        }
        for (Map.Entry entry : dependencyMap.entrySet()) {
            AddonVertex vertex = this.getOrCreateVertex(((AddonId)entry.getKey()).getName(), ((AddonId)entry.getKey()).getVersion());
            for (AddonDependencyEntry dependency : (Set)entry.getValue()) {
                boolean satisfied = false;
                for (AddonId id : enabled) {
                    if (!dependency.getName().equals(id.getName()) || !dependency.getVersionRange().includes(id.getVersion())) continue;
                    AddonVertex dependencyVertex = this.getOrCreateVertex(id.getName(), id.getVersion());
                    this.graph.addEdge((Object)vertex, (Object)dependencyVertex, (Object)new AddonDependencyEdge(dependency.getVersionRange(), dependency.isExported()));
                    satisfied = true;
                }
                if (satisfied || dependency.isOptional()) continue;
                AddonVertex missingVertex = new AddonVertex(dependency.getName(), EmptyVersion.getInstance());
                this.graph.addVertex((Object)missingVertex);
                this.graph.addEdge((Object)vertex, (Object)missingVertex, (Object)new AddonDependencyEdge(dependency.getVersionRange(), dependency.isExported()));
            }
        }
        CycleDetector detector = new CycleDetector(this.graph);
        if (detector.detectCycles()) {
            throw new IllegalStateException("Cycle detected in Addon graph: " + detector.findCycles());
        }
    }

    private Set<AddonId> getAllEnabledAddonsInAllRepositories(Collection<AddonRepository> repositories) {
        HashSet<AddonId> result = new HashSet<AddonId>();
        for (AddonRepository repository : repositories) {
            List enabled = repository.listEnabled();
            List enabledCompatible = repository.listEnabledCompatibleWithVersion(AddonRepositoryImpl.getRuntimeAPIVersion());
            result.addAll(enabledCompatible);
            ArrayList incompatible = new ArrayList(enabled);
            incompatible.removeAll(enabledCompatible);
            for (AddonId addon : incompatible) {
                if (addon.getApiVersion() == null) continue;
                this.logger.warning("Addon [" + addon + "] with API version [" + addon.getApiVersion() + "] is incompatible with the current Furnace runtime version [" + AddonRepositoryImpl.getRuntimeAPIVersion() + "] and will not be loaded, from repository [" + repository + "]");
            }
        }
        return result;
    }

    @Override
    public DirectedGraph<AddonVertex, AddonDependencyEdge> getGraph() {
        return this.graph;
    }
}

