/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config;

import com.thinkaurelius.titan.core.TitanGraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jboss.forge.furnace.spi.ListenerRegistration;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RuleLifecycleListener;
import org.jboss.windup.config.Variables;
import org.jboss.windup.config.metadata.RuleMetadataType;
import org.jboss.windup.config.phase.RulePhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.performance.RulePhaseExecutionStatisticsModel;
import org.jboss.windup.graph.model.performance.RuleProviderExecutionStatisticsModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.RuleProviderExecutionStatisticsService;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.config.CompositeOperation;
import org.ocpsoft.rewrite.config.CompositeRule;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.ConditionVisit;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.DefaultOperationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.OperationVisit;
import org.ocpsoft.rewrite.config.ParameterizedCallback;
import org.ocpsoft.rewrite.config.ParameterizedConditionVisitor;
import org.ocpsoft.rewrite.config.ParameterizedOperationVisitor;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.config.RuleBuilder;
import org.ocpsoft.rewrite.config.RuleMetadata;
import org.ocpsoft.rewrite.context.Context;
import org.ocpsoft.rewrite.context.ContextBase;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.context.RewriteState;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ConfigurableParameter;
import org.ocpsoft.rewrite.param.Constraint;
import org.ocpsoft.rewrite.param.DefaultParameter;
import org.ocpsoft.rewrite.param.DefaultParameterStore;
import org.ocpsoft.rewrite.param.DefaultParameterValueStore;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterValueStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.Transposition;
import org.ocpsoft.rewrite.util.ParameterUtils;
import org.ocpsoft.rewrite.util.Visitor;

public class RuleSubset
extends DefaultOperationBuilder
implements CompositeOperation,
Parameterized,
CompositeRule {
    private static Logger log = Logger.getLogger(RuleSubset.class.getName());
    private final IdentityHashMap<AbstractRuleProvider, Object> timeTakenByProvider = new IdentityHashMap();
    private final Map<Class<? extends RulePhase>, Object> timeTakenByPhase = new HashMap<Class<? extends RulePhase>, Object>();
    private final Configuration config;
    private List<RuleLifecycleListener> listeners = new ArrayList<RuleLifecycleListener>();

    private RuleSubset(Configuration config) {
        Assert.notNull((Object)config, (String)"Configuration must not be null.");
        this.config = config;
    }

    public static RuleSubset create(Configuration config) {
        return new RuleSubset(config);
    }

    private void logTimeTakenByRuleProvider(GraphContext graphContext, Context context, int ruleIndex, int timeTaken) {
        AbstractRuleProvider ruleProvider = (AbstractRuleProvider)context.get((Object)RuleMetadataType.RULE_PROVIDER);
        if (ruleProvider == null) {
            return;
        }
        if (!this.timeTakenByProvider.containsKey(ruleProvider)) {
            RuleProviderExecutionStatisticsModel model = (RuleProviderExecutionStatisticsModel)new RuleProviderExecutionStatisticsService(graphContext).create();
            model.setRuleIndex(ruleIndex);
            model.setRuleProviderID(ruleProvider.getMetadata().getID());
            model.setTimeTaken(timeTaken);
            this.timeTakenByProvider.put(ruleProvider, model.asVertex().getId());
        } else {
            RuleProviderExecutionStatisticsService service = new RuleProviderExecutionStatisticsService(graphContext);
            RuleProviderExecutionStatisticsModel model = (RuleProviderExecutionStatisticsModel)service.getById(this.timeTakenByProvider.get(ruleProvider));
            int prevTimeTaken = model.getTimeTaken();
            model.setTimeTaken(prevTimeTaken + timeTaken);
        }
        this.logTimeTakenByPhase(graphContext, ruleProvider.getMetadata().getPhase(), timeTaken);
    }

    private void logTimeTakenByPhase(GraphContext graphContext, Class<? extends RulePhase> phase, int timeTaken) {
        if (!this.timeTakenByPhase.containsKey(phase)) {
            RulePhaseExecutionStatisticsModel model = (RulePhaseExecutionStatisticsModel)new GraphService(graphContext, RulePhaseExecutionStatisticsModel.class).create();
            model.setRulePhase(phase.toString());
            model.setTimeTaken(timeTaken);
            model.setOrderExecuted(this.timeTakenByPhase.size());
            this.timeTakenByPhase.put(phase, model.asVertex().getId());
        } else {
            GraphService service = new GraphService(graphContext, RulePhaseExecutionStatisticsModel.class);
            RulePhaseExecutionStatisticsModel model = (RulePhaseExecutionStatisticsModel)service.getById(this.timeTakenByPhase.get(phase));
            int prevTimeTaken = model.getTimeTaken();
            model.setTimeTaken(prevTimeTaken + timeTaken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(Rewrite rewrite, EvaluationContext context) {
        if (!(rewrite instanceof GraphRewrite)) {
            throw new IllegalArgumentException("Rewrite must be an instanceof GraphRewrite");
        }
        GraphRewrite event = (GraphRewrite)rewrite;
        List rules = this.config.getRules();
        for (RuleLifecycleListener listener : this.listeners) {
            listener.beforeExecution(event);
        }
        EvaluationContextImpl subContext = new EvaluationContextImpl();
        for (int i = 0; i < rules.size(); ++i) {
            Rule rule = (Rule)rules.get(i);
            Context ruleContext = rule instanceof Context ? (Context)rule : null;
            long ruleTimeStarted = System.currentTimeMillis();
            try {
                subContext = new EvaluationContextImpl();
                ParameterStore parameterStore = (ParameterStore)context.get(ParameterStore.class);
                if (parameterStore == null) {
                    parameterStore = new DefaultParameterStore();
                }
                subContext.put(ParameterStore.class, parameterStore);
                this.setParameterStore(parameterStore);
                ParameterValueStore values = (ParameterValueStore)context.get(ParameterValueStore.class);
                if (values == null) {
                    values = new DefaultParameterValueStore();
                }
                subContext.put(ParameterValueStore.class, values);
                subContext.setState(RewriteState.EVALUATING);
                subContext.put(Rule.class, rule);
                Variables.instance(event).push();
                try {
                    for (RuleLifecycleListener listener : this.listeners) {
                        listener.beforeRuleEvaluation(event, rule, subContext);
                    }
                    if (rule.evaluate((Rewrite)event, (EvaluationContext)subContext)) {
                        for (RuleLifecycleListener listener : this.listeners) {
                            listener.afterRuleConditionEvaluation(event, subContext, rule, true);
                        }
                        if (!this.handleBindings(event, subContext, values)) continue;
                        subContext.setState(RewriteState.PERFORMING);
                        Object ruleProviderDesc = ((RuleBuilder)rule).get((Object)RuleMetadataType.RULE_PROVIDER);
                        log.info("Rule [" + ruleProviderDesc + "] matched and will be performed.");
                        for (RuleLifecycleListener listener : this.listeners) {
                            listener.beforeRuleOperationsPerformed(event, subContext, rule);
                        }
                        List<Operation> preOperations = subContext.getPreOperations();
                        for (Operation preOperation : preOperations) {
                            preOperation.perform((Rewrite)event, (EvaluationContext)subContext);
                        }
                        if (event.getFlow().isHandled()) break;
                        rule.perform((Rewrite)event, (EvaluationContext)subContext);
                        for (RuleLifecycleListener listener : this.listeners) {
                            listener.afterRuleOperationsPerformed(event, subContext, rule);
                        }
                        if (event.getFlow().isHandled()) break;
                        List<Operation> postOperations = subContext.getPostOperations();
                        for (Operation postOperation : postOperations) {
                            postOperation.perform((Rewrite)event, (EvaluationContext)subContext);
                        }
                        if (event.getFlow().isHandled()) break;
                        continue;
                    }
                    for (RuleLifecycleListener listener : this.listeners) {
                        listener.afterRuleConditionEvaluation(event, subContext, rule, false);
                    }
                    continue;
                }
                finally {
                    boolean autocommit = true;
                    if (ruleContext != null && ruleContext.containsKey((Object)RuleMetadataType.AUTO_COMMIT)) {
                        autocommit = (Boolean)ruleContext.get((Object)RuleMetadataType.AUTO_COMMIT);
                    }
                    if (autocommit) {
                        ((TitanGraph)event.getGraphContext().getGraph().getBaseGraph()).commit();
                    }
                    Variables.instance(event).pop();
                    long ruleTimeCompleted = System.currentTimeMillis();
                    if (ruleContext != null) {
                        int timeTaken = (int)(ruleTimeCompleted - ruleTimeStarted);
                        this.logTimeTakenByRuleProvider(event.getGraphContext(), ruleContext, i, timeTaken);
                    }
                }
            }
            catch (RuntimeException ex) {
                for (RuleLifecycleListener listener : this.listeners) {
                    listener.afterRuleExecutionFailed(event, subContext, rule, ex);
                }
                String exMsg = "Error encountered while evaluating rule: " + rule;
                String logMsg = exMsg + "\n" + StringUtils.defaultString((String)ex.getMessage(), (String)"(Exception message is not set)");
                log.log(Level.SEVERE, logMsg, ex);
                if (ruleContext != null) {
                    Object location;
                    Object origin = ruleContext.get((Object)RuleMetadataType.ORIGIN);
                    if (origin != null) {
                        exMsg = exMsg + "\n  From: " + origin;
                    }
                    if ((location = ruleContext.get((Object)RuleMetadata.PROVIDER_LOCATION)) != null) {
                        exMsg = exMsg + "\n  Defined in: " + location;
                    }
                }
                throw new WindupException(exMsg, (Throwable)ex);
            }
        }
        for (RuleLifecycleListener listener : this.listeners) {
            listener.afterExecution(event);
        }
    }

    private boolean handleBindings(Rewrite event, EvaluationContextImpl context, ParameterValueStore valueStore) {
        boolean result = true;
        ParameterStore store = (ParameterStore)context.get(ParameterStore.class);
        for (Map.Entry entry : store) {
            String values;
            Parameter parameter = (Parameter)entry.getValue();
            if (ParameterUtils.enqueueSubmission((Rewrite)event, (EvaluationContext)context, (Parameter)parameter, (Object)(values = valueStore.retrieve(parameter)))) continue;
            result = false;
            break;
        }
        return result;
    }

    public List<Operation> getOperations() {
        return Collections.emptyList();
    }

    public Set<String> getRequiredParameterNames() {
        return Collections.emptySet();
    }

    public void setParameterStore(ParameterStore parent) {
        for (int i = 0; i < this.config.getRules().size(); ++i) {
            Rule rule = (Rule)this.config.getRules().get(i);
            if (!(rule instanceof RuleBuilder)) continue;
            ParameterizedCallbackImpl callback = new ParameterizedCallbackImpl(rule, parent);
            ParameterizedConditionVisitor conditionVisitor = new ParameterizedConditionVisitor((ParameterizedCallback)callback);
            new ConditionVisit((Condition)rule).accept((Visitor)conditionVisitor);
            ParameterizedOperationVisitor operationVisitor = new ParameterizedOperationVisitor((ParameterizedCallback)callback);
            new OperationVisit((Operation)rule).accept((Visitor)operationVisitor);
        }
    }

    public ListenerRegistration<RuleLifecycleListener> addLifecycleListener(final RuleLifecycleListener listener) {
        this.listeners.add(listener);
        return new ListenerRegistration<RuleLifecycleListener>(){

            public RuleLifecycleListener removeListener() {
                RuleSubset.this.listeners.remove(listener);
                return listener;
            }
        };
    }

    public String getId() {
        return "RuleSubset_" + this.config.hashCode();
    }

    public boolean evaluate(Rewrite event, EvaluationContext context) {
        return this.config != null && this.config.getRules() != null && !this.config.getRules().isEmpty();
    }

    public List<Rule> getRules() {
        return this.config == null ? null : this.config.getRules();
    }

    public String toString() {
        return "RuleSubset.create(" + this.config + ")";
    }

    private static class ParameterizedCallbackImpl
    implements ParameterizedCallback {
        private final Rule rule;
        private final ParameterStore parent;

        public ParameterizedCallbackImpl(Rule rule, ParameterStore parent) {
            this.rule = rule;
            this.parent = parent;
        }

        public void call(Parameterized parameterized) {
            Set names = parameterized.getRequiredParameterNames();
            if (!(this.rule instanceof RuleBuilder)) {
                return;
            }
            ParameterStore store = ((RuleBuilder)this.rule).getParameterStore();
            for (Map.Entry entry : this.parent) {
                String name = (String)entry.getKey();
                Parameter parentParam = (Parameter)entry.getValue();
                if (!store.contains(name)) {
                    store.get(name, parentParam);
                    continue;
                }
                Parameter parameter = store.get(name);
                for (Binding binding : parameter.getBindings()) {
                    if (parentParam.getBindings().contains(binding)) continue;
                    this.throwRedefinitionError(this.rule, name);
                }
                for (Constraint constraint : parameter.getConstraints()) {
                    if (parentParam.getConstraints().contains(constraint)) continue;
                    this.throwRedefinitionError(this.rule, name);
                }
                for (Transposition transposition : parameter.getTranspositions()) {
                    if (parentParam.getTranspositions().contains(transposition)) continue;
                    this.throwRedefinitionError(this.rule, name);
                }
                if (parentParam.getConverter() != null && !parentParam.getConverter().equals(parameter.getConverter())) {
                    this.throwRedefinitionError(this.rule, name);
                }
                if (parentParam.getValidator() == null || parentParam.getValidator().equals(parameter.getValidator())) continue;
                this.throwRedefinitionError(this.rule, name);
            }
            for (String name : names) {
                Parameter parameter = store.get(name, (Parameter)new DefaultParameter(name));
                if (!(parameter instanceof ConfigurableParameter)) continue;
                ((ConfigurableParameter)parameter).bindsTo((Binding)Evaluation.property((String)name));
            }
            parameterized.setParameterStore(store);
        }

        private void throwRedefinitionError(Rule rule, String name) {
            throw new IllegalStateException("Subset cannot re-configure parameter [" + name + "] that was configured in parent Configuration. Re-definition was attempted at [" + rule + "] ");
        }
    }

    private static class EvaluationContextImpl
    extends ContextBase
    implements EvaluationContext {
        private final List<Operation> preOperations = new ArrayList<Operation>();
        private final List<Operation> postOperations = new ArrayList<Operation>();
        private RewriteState state;

        public EvaluationContextImpl() {
            this.put(ParameterStore.class, new DefaultParameterStore());
        }

        public void addPreOperation(Operation operation) {
            this.preOperations.add(operation);
        }

        public void addPostOperation(Operation operation) {
            this.preOperations.add(operation);
        }

        public List<Operation> getPreOperations() {
            return Collections.unmodifiableList(this.preOperations);
        }

        public List<Operation> getPostOperations() {
            return Collections.unmodifiableList(this.postOperations);
        }

        public String toString() {
            return "EvaluationContextImpl [preOperations=" + this.preOperations + ", postOperations=" + this.postOperations + "]";
        }

        public RewriteState getState() {
            return this.state;
        }

        public void setState(RewriteState state) {
            this.state = state;
        }
    }
}

