/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.operation;

import java.util.logging.Logger;
import org.jboss.forge.furnace.util.Iterators;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class IterationProgress
extends AbstractIterationOperation<WindupVertexFrame> {
    private static final Logger LOG = Logging.get(IterationProgress.class);
    private String messagePrefix;
    private int interval;
    private int totalIterations = -1;
    private int currentIteration = 0;

    public IterationProgress(String messagePrefix, int interval) {
        this.messagePrefix = messagePrefix;
        this.interval = interval;
    }

    public static IterationProgress monitoring(String messagePrefix, int interval) {
        return new IterationProgress(messagePrefix, interval);
    }

    @Override
    public void perform(GraphRewrite event, EvaluationContext context, WindupVertexFrame payload) {
        if (this.totalIterations == -1) {
            Iterable frames = (Iterable)event.getRewriteContext().get((Object)"default");
            this.totalIterations = Iterators.asList((Iterable)frames).size();
        }
        ++this.currentIteration;
        if (this.currentIteration % this.interval == 0) {
            LOG.info(this.messagePrefix + this.currentIteration + " / " + this.totalIterations);
        }
    }
}

