/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import com.thinkaurelius.titan.core.util.TitanCleanup;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.wrappers.batch.BatchGraph;
import com.tinkerpop.blueprints.util.wrappers.event.EventGraph;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.FramedGraphConfiguration;
import com.tinkerpop.frames.FramedGraphFactory;
import com.tinkerpop.frames.modules.FrameClassLoaderResolver;
import com.tinkerpop.frames.modules.MethodHandler;
import com.tinkerpop.frames.modules.Module;
import com.tinkerpop.frames.modules.gremlingroovy.GremlinGroovyModule;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerModule;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.windup.graph.GraphApiCompositeClassLoaderProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphTypeRegistry;
import org.jboss.windup.graph.MapInAdjacentPropertiesHandler;
import org.jboss.windup.graph.MapInAdjacentVerticesHandler;
import org.jboss.windup.graph.MapInPropertiesHandler;
import org.jboss.windup.graph.frames.TypeAwareFramedGraphQuery;
import org.jboss.windup.graph.listeners.AfterGraphInitializationListener;
import org.jboss.windup.graph.listeners.BeforeGraphCloseListener;

public class GraphContextImpl
implements GraphContext {
    private static final Logger log = Logger.getLogger(GraphContextImpl.class.getName());
    private Furnace furnace;
    private Map<String, Object> configurationOptions;
    private final GraphTypeRegistry graphTypeRegistry;
    private EventGraph<TitanGraph> eventGraph;
    private BatchGraph<TitanGraph> batchGraph;
    private FramedGraph<EventGraph<TitanGraph>> framed;
    private Configuration conf;
    private final Path graphDir;
    private GraphApiCompositeClassLoaderProvider classLoaderProvider;

    public GraphContextImpl(Furnace furnace, GraphTypeRegistry graphTypeRegistry, GraphApiCompositeClassLoaderProvider classLoaderProvider, Path graphDir) {
        this.furnace = furnace;
        this.graphTypeRegistry = graphTypeRegistry;
        this.classLoaderProvider = classLoaderProvider;
        this.graphDir = graphDir;
    }

    public GraphContextImpl create() {
        FileUtils.deleteQuietly((File)this.graphDir.toFile());
        TitanGraph titan = this.initializeTitanGraph();
        this.initializeTitanManagement(titan);
        this.createFramed(titan);
        this.fireListeners();
        return this;
    }

    public GraphContextImpl load() {
        TitanGraph titan = this.initializeTitanGraph();
        this.createFramed(titan);
        this.fireListeners();
        return this;
    }

    private void fireListeners() {
        Imported afterInitializationListeners = this.furnace.getAddonRegistry(new AddonRepository[0]).getServices(AfterGraphInitializationListener.class);
        HashMap<String, Object> confProps = new HashMap<String, Object>();
        Iterator keyIter = this.conf.getKeys();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            confProps.put(key, this.conf.getProperty(key));
        }
        if (!afterInitializationListeners.isUnsatisfied()) {
            for (AfterGraphInitializationListener listener : afterInitializationListeners) {
                listener.afterGraphStarted(confProps, (GraphContext)this);
            }
        }
    }

    private void createFramed(TitanGraph titanGraph) {
        this.eventGraph = new EventGraph((Graph)titanGraph);
        this.batchGraph = new BatchGraph((TransactionalGraph)titanGraph, 1000L);
        final ClassLoader compositeClassLoader = this.classLoaderProvider.getCompositeClassLoader();
        final FrameClassLoaderResolver fclr = new FrameClassLoaderResolver(){

            public ClassLoader resolveClassLoader(Class<?> frameType) {
                return compositeClassLoader;
            }
        };
        Module addModules = new Module(){

            public Graph configure(Graph baseGraph, FramedGraphConfiguration config) {
                config.setFrameClassLoaderResolver(fclr);
                config.addMethodHandler((MethodHandler)new MapInPropertiesHandler());
                config.addMethodHandler((MethodHandler)new MapInAdjacentPropertiesHandler());
                config.addMethodHandler((MethodHandler)new MapInAdjacentVerticesHandler());
                return baseGraph;
            }
        };
        FramedGraphFactory factory = new FramedGraphFactory(new Module[]{addModules, new JavaHandlerModule(), this.graphTypeRegistry.build(), new GremlinGroovyModule()});
        this.framed = factory.create(this.eventGraph);
    }

    private void initializeTitanManagement(TitanGraph titanGraph) {
        PropertyKey propKey;
        String[] keys = new String[]{"namespaceURI", "schemaLocation", "publicId", "rootTagName", "systemId", "qualifiedName", "filePath", "mavenIdentifier", "packageName", "classification"};
        TitanManagement mgmt = titanGraph.getManagementSystem();
        for (String key : keys) {
            propKey = mgmt.makePropertyKey(key).dataType(String.class).cardinality(Cardinality.SINGLE).make();
            mgmt.buildIndex(key, Vertex.class).addKey(propKey).buildCompositeIndex();
        }
        for (String key : new String[]{"referenceSourceSnippit"}) {
            propKey = mgmt.makePropertyKey(key).dataType(String.class).cardinality(Cardinality.SINGLE).make();
            mgmt.buildIndex(key, Vertex.class).addKey(propKey).buildMixedIndex("search");
        }
        for (String key : new String[]{"w:vertextype"}) {
            propKey = mgmt.makePropertyKey(key).dataType(String.class).cardinality(Cardinality.LIST).make();
            mgmt.buildIndex(key, Vertex.class).addKey(propKey).buildCompositeIndex();
        }
        mgmt.commit();
    }

    private TitanGraph initializeTitanGraph() {
        log.fine("Initializing graph.");
        Path lucene = this.graphDir.resolve("graphsearch");
        Path berkeley = this.graphDir.resolve("titangraph");
        this.conf = new BaseConfiguration();
        this.conf.setProperty("storage.directory", (Object)berkeley.toAbsolutePath().toString());
        this.conf.setProperty("storage.backend", (Object)"berkeleyje");
        this.conf.setProperty("storage.berkeleydb.cache-percentage", (Object)1);
        this.conf.setProperty("cache.db-cache", (Object)true);
        this.conf.setProperty("cache.db-cache-clean-wait", (Object)0);
        this.conf.setProperty("cache.db-cache-size", (Object)0.05);
        this.conf.setProperty("cache.db-cache-time", (Object)0);
        this.conf.setProperty("index.search.backend", (Object)"lucene");
        this.conf.setProperty("index.search.directory", (Object)lucene.toAbsolutePath().toString());
        return TitanFactory.open((Configuration)this.conf);
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public GraphTypeRegistry getGraphTypeRegistry() {
        return this.graphTypeRegistry;
    }

    public void close() {
        Imported beforeCloseListeners = this.furnace.getAddonRegistry(new AddonRepository[0]).getServices(BeforeGraphCloseListener.class);
        for (BeforeGraphCloseListener listener : beforeCloseListeners) {
            listener.beforeGraphClose();
        }
        ((TitanGraph)this.eventGraph.getBaseGraph()).shutdown();
    }

    public void clear() {
        TitanCleanup.clear((TitanGraph)((TitanGraph)this.eventGraph.getBaseGraph()));
    }

    public EventGraph<TitanGraph> getGraph() {
        return this.eventGraph;
    }

    public BatchGraph<TitanGraph> getBatch() {
        return this.batchGraph;
    }

    public FramedGraph<EventGraph<TitanGraph>> getFramed() {
        return this.framed;
    }

    public TypeAwareFramedGraphQuery getQuery() {
        return new TypeAwareFramedGraphQuery(this.getFramed());
    }

    public Path getGraphDirectory() {
        return this.graphDir;
    }

    public Map<String, Object> getOptionMap() {
        return Collections.unmodifiableMap(this.configurationOptions);
    }

    public void setOptions(Map<String, Object> options) {
        this.configurationOptions = options;
    }

    public String toString() {
        String graphHash = this.getGraph() == null ? "null" : "" + this.getGraph().hashCode();
        return "GraphContextImpl(" + this.hashCode() + "), Graph(" + graphHash + ") + DataDir(" + this.getGraphDirectory() + ")";
    }
}

