/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.Version;
import org.apache.maven.index.Field;
import org.apache.maven.index.IndexerField;
import org.apache.maven.index.QueryCreator;
import org.apache.maven.index.SearchType;
import org.apache.maven.index.context.NexusAnalyzer;
import org.apache.maven.index.creator.JarFileContentsIndexCreator;
import org.apache.maven.index.creator.MinimalArtifactInfoIndexCreator;
import org.apache.maven.index.expr.SearchExpression;
import org.apache.maven.index.expr.SearchTyped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultQueryCreator
implements QueryCreator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private NexusAnalyzer nexusAnalyzer = new NexusAnalyzer();

    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public IndexerField selectIndexerField(Field field, SearchType type) {
        IndexerField lastField = null;
        Iterator<IndexerField> i$ = field.getIndexerFields().iterator();
        while (i$.hasNext()) {
            IndexerField indexerField;
            lastField = indexerField = i$.next();
            if (!type.matchesIndexerField(indexerField)) continue;
            return indexerField;
        }
        return lastField;
    }

    @Override
    public Query constructQuery(Field field, SearchExpression expression) throws ParseException {
        SearchType searchType = SearchType.SCORED;
        if (expression instanceof SearchTyped) {
            searchType = ((SearchTyped)((Object)expression)).getSearchType();
        }
        return this.constructQuery(field, expression.getStringValue(), searchType);
    }

    @Override
    public Query constructQuery(Field field, String query, SearchType type) throws ParseException {
        if (type == null) {
            throw new NullPointerException("Cannot construct query with type of \"null\"!");
        }
        if (field == null) {
            throw new NullPointerException("Cannot construct query for field \"null\"!");
        }
        return this.constructQuery(field, this.selectIndexerField(field, type), query, type);
    }

    @Override
    @Deprecated
    public Query constructQuery(String field, String query) {
        Query result = null;
        if (MinimalArtifactInfoIndexCreator.FLD_GROUP_ID_KW.getKey().equals(field) || MinimalArtifactInfoIndexCreator.FLD_ARTIFACT_ID_KW.getKey().equals(field) || MinimalArtifactInfoIndexCreator.FLD_VERSION_KW.getKey().equals(field) || JarFileContentsIndexCreator.FLD_CLASSNAMES_KW.getKey().equals(field)) {
            result = this.legacyConstructQuery(field, query);
        } else {
            QueryParser qp = new QueryParser(Version.LUCENE_46, field, (Analyzer)new NexusAnalyzer());
            if (!query.contains(":") && query.contains("*") && query.matches(".*(\\.|-|_).*")) {
                query = query.toLowerCase().replaceAll("\\*", "X").replaceAll("\\.|-|_", " ").replaceAll("X", "*");
            }
            try {
                result = qp.parse(query);
            }
            catch (ParseException e) {
                this.getLogger().debug("Query parsing with \"legacy\" method, we got ParseException from QueryParser: " + e.getMessage());
                result = this.legacyConstructQuery(field, query);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Query parsed as: " + result.toString());
        }
        return result;
    }

    public Query constructQuery(Field field, IndexerField indexerField, String query, SearchType type) throws ParseException {
        if (indexerField == null) {
            this.getLogger().warn("Querying for field \"" + field.toString() + "\" without any indexer field was tried. Please review your code, and consider adding this field to index!");
            return null;
        }
        if (!indexerField.isIndexed()) {
            this.getLogger().warn("Querying for non-indexed field " + field.toString() + " was tried. Please review your code or consider adding this field to index!");
            return null;
        }
        if (query.startsWith("*") || query.startsWith("?")) {
            throw new ParseException("Query cannot start with '*' or '?'!");
        }
        if ("N/P".equals(query)) {
            return new WildcardQuery(new Term(indexerField.getKey(), "*"));
        }
        if (SearchType.EXACT.equals((Object)type)) {
            if (indexerField.isKeyword()) {
                if (query.contains("*") || query.contains("?")) {
                    return new WildcardQuery(new Term(indexerField.getKey(), query));
                }
                return new TermQuery(new Term(indexerField.getKey(), query));
            }
            if (!indexerField.isKeyword() && indexerField.isStored()) {
                if (JarFileContentsIndexCreator.FLD_CLASSNAMES_KW.equals(indexerField)) {
                    if (query.startsWith("/")) {
                        return new TermQuery(new Term(indexerField.getKey(), query.toLowerCase().replaceAll("\\.", "/")));
                    }
                    return new TermQuery(new Term(indexerField.getKey(), "/" + query.toLowerCase().replaceAll("\\.", "/")));
                }
                this.getLogger().warn(type.toString() + " type of querying for non-keyword (but stored) field " + indexerField.getOntology().toString() + " was tried. Please review your code, or indexCreator involved, since this type of querying of this field is currently unsupported.");
                return null;
            }
            this.getLogger().warn(type.toString() + " type of querying for non-keyword (and not stored) field " + indexerField.getOntology().toString() + " was tried. Please review your code, or indexCreator involved, since this type of querying of this field is impossible.");
            return null;
        }
        if (SearchType.SCORED.equals((Object)type)) {
            IndexerField keywordField;
            if (JarFileContentsIndexCreator.FLD_CLASSNAMES.equals(indexerField)) {
                String qpQuery = query.toLowerCase().replaceAll("\\.", " ").replaceAll("/", " ");
                QueryParser qp = new QueryParser(Version.LUCENE_46, indexerField.getKey(), (Analyzer)new NexusAnalyzer());
                qp.setDefaultOperator(QueryParser.Operator.AND);
                return qp.parse(qpQuery);
            }
            if (indexerField.isKeyword()) {
                if (query.contains("*") || query.contains("?")) {
                    return new WildcardQuery(new Term(indexerField.getKey(), query));
                }
                BooleanQuery bq = new BooleanQuery();
                Term t = new Term(indexerField.getKey(), query);
                bq.add((Query)new TermQuery(t), BooleanClause.Occur.SHOULD);
                PrefixQuery pq = new PrefixQuery(t);
                pq.setBoost(0.8f);
                bq.add((Query)pq, BooleanClause.Occur.SHOULD);
                return bq;
            }
            String qpQuery = query;
            QueryParser qp = new QueryParser(Version.LUCENE_46, indexerField.getKey(), (Analyzer)new NexusAnalyzer());
            qp.setDefaultOperator(QueryParser.Operator.AND);
            if (qpQuery.matches(".*(\\.|-|_|/).*")) {
                qpQuery = qpQuery.toLowerCase().replaceAll("\\*", "X").replaceAll("\\.|-|_|/", " ").replaceAll("X", "*").replaceAll(" \\* ", "").replaceAll("^\\* ", "").replaceAll(" \\*$", "");
            }
            if (!qpQuery.endsWith("*") && !qpQuery.endsWith(" ")) {
                qpQuery = qpQuery + "*";
            }
            BooleanQuery q1 = new BooleanQuery();
            q1.add(qp.parse(qpQuery), BooleanClause.Occur.SHOULD);
            if (qpQuery.contains(" ")) {
                q1.add(qp.parse("\"" + qpQuery + "\""), BooleanClause.Occur.SHOULD);
            }
            Query q2 = null;
            int termCount = this.countTerms(indexerField, query);
            if (!query.contains(" ") && termCount > 1 && (keywordField = this.selectIndexerField(indexerField.getOntology(), SearchType.EXACT)).isKeyword()) {
                q2 = this.constructQuery(indexerField.getOntology(), keywordField, query, type);
            }
            if (q2 == null) {
                return q1;
            }
            BooleanQuery bq = new BooleanQuery();
            bq.add(q2, BooleanClause.Occur.SHOULD);
            bq.add((Query)q1, BooleanClause.Occur.SHOULD);
            return bq;
        }
        return null;
    }

    public Query legacyConstructQuery(String field, String query) {
        int l;
        char c;
        if (query == null || query.length() == 0) {
            this.getLogger().info("Empty or null query for field:" + field);
            return null;
        }
        String q = query.toLowerCase();
        char h = query.charAt(0);
        if (JarFileContentsIndexCreator.FLD_CLASSNAMES_KW.getKey().equals(field) || JarFileContentsIndexCreator.FLD_CLASSNAMES.getKey().equals(field)) {
            q = q.replaceAll("\\.", "/");
            if (h == '^') {
                if ((q = q.substring(1)).charAt(0) != '/') {
                    q = '/' + q;
                }
            } else if (h != '*') {
                q = "*/" + q;
            }
        } else if (h == '^') {
            q = q.substring(1);
        } else if (h != '*') {
            q = "*" + q;
        }
        if ((c = q.charAt(l = q.length() - 1)) == ' ' || c == '<' || c == '$') {
            q = q.substring(0, q.length() - 1);
        } else if (c != '*') {
            q = q + "*";
        }
        int n = q.indexOf(42);
        if (n == -1) {
            return new TermQuery(new Term(field, q));
        }
        if (n > 0 && n == q.length() - 1) {
            return new PrefixQuery(new Term(field, q.substring(0, q.length() - 1)));
        }
        return new WildcardQuery(new Term(field, q));
    }

    protected int countTerms(IndexerField indexerField, String query) {
        try {
            TokenStream ts = this.nexusAnalyzer.tokenStream(indexerField.getKey(), new StringReader(query));
            ts.reset();
            int result = 0;
            while (ts.incrementToken()) {
                ++result;
            }
            ts.end();
            ts.close();
            return result;
        }
        catch (IOException e) {
            return 1;
        }
    }
}

